/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;

public class Coinbase {
    Transaction tx;
    byte[] tx_data;
    byte[] script_bytes;
    byte[] extranonce1;
    byte[] extranonce2;
    Address pay_to_addr;
    NetworkParameters params;
    BigInteger value;
    public static final int BLOCK_HEIGHT_OFF = 0;
    public static final int EXTRA1_OFF = 4;
    public static final int EXTRA2_OFF = 8;
    public static final int RANDOM_OFF = 12;

    public Coinbase(NetworkParameters params, int block_height, Address pay_to_addr, BigInteger value, byte[] extranonce1) {
        int i;
        this.params = params;
        this.pay_to_addr = pay_to_addr;
        this.value = value;
        this.extranonce1 = extranonce1;
        this.extranonce2 = new byte[4];
        byte[] height_array = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(height_array);
        bb.putInt(block_height);
        height_array[0] = 3;
        String script = "BLKHEXT1EXT2RNDN/SockThing/Stratum";
        this.script_bytes = script.getBytes();
        for (i = 0; i < 4; ++i) {
            this.script_bytes[i + 0] = height_array[i];
        }
        this.script_bytes[1] = height_array[3];
        this.script_bytes[3] = height_array[1];
        for (i = 0; i < 4; ++i) {
            this.script_bytes[i + 4] = extranonce1[i];
        }
        byte[] rand = new byte[4];
        Random rnd = new Random();
        rnd.nextBytes(rand);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.script_bytes[i2 + 12] = rand[i2];
        }
        this.genTx();
    }

    public Transaction genTx() {
        this.tx = new Transaction(this.params);
        this.tx.addInput(new TransactionInput(this.params, this.tx, this.script_bytes));
        this.tx.addOutput(this.value, this.pay_to_addr);
        this.tx_data = this.tx.bitcoinSerialize();
        return this.tx;
    }

    public void setExtranonce2(byte[] extranonce2) {
        for (int i = 0; i < 4; ++i) {
            this.script_bytes[i + 8] = extranonce2[i];
        }
    }

    public byte[] getCoinbase1() {
        int cb1_size = 46;
        byte[] buff = new byte[46];
        for (int i = 0; i < cb1_size; ++i) {
            buff[i] = this.tx_data[i];
        }
        return buff;
    }

    public byte[] getCoinbase2() {
        int sz = this.tx_data.length - 42 - 4 - 8;
        byte[] buff = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            buff[i] = this.tx_data[i + 42 + 8 + 4];
        }
        return buff;
    }

    public static void main(String[] args) throws Exception {
        NetworkParameters params = NetworkParameters.prodNet();
        byte[] extra1 = new byte[4];
        for (int i = 0; i < 4; ++i) {
            extra1[i] = (byte)(i + 1);
        }
        Coinbase cb = new Coinbase(params, 32010, new Address(params, "15vkb5XdTrZW1oKByjaqdTsUjdSri2uREN"), BigInteger.valueOf(2500000000L), extra1);
        Transaction tx = cb.genTx();
        System.out.println(tx.getHash());
        System.out.println(tx);
        tx = cb.genTx();
        System.out.println(tx.getHash());
        System.out.println(tx);
        cb.setExtranonce2(extra1);
        tx = cb.genTx();
        System.out.println(tx.getHash());
        System.out.println(tx);
        for (TransactionOutput out : tx.getOutputs()) {
            System.out.println("  out: " + out);
        }
        byte[] data = tx.bitcoinSerialize();
        System.out.println(Hex.encodeHexString(data));
        System.out.println(Hex.encodeHexString(cb.getCoinbase1()));
        System.out.println(Hex.encodeHexString(cb.getCoinbase2()));
    }
}

