/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.UnsafeByteArrayOutputStream;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends ChildMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    private static final long serialVersionUID = -8567546957352643140L;
    private long version;
    private ArrayList<TransactionInput> inputs;
    private ArrayList<TransactionOutput> outputs;
    private long lockTime;
    Set<StoredBlock> appearsIn;
    Date updatedAt;
    transient Sha256Hash hash;
    private TransactionConfidence confidence;
    Set<Sha256Hash> appearsInHashes;

    public Transaction(NetworkParameters params) {
        super(params);
        this.version = 1L;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.length = 8;
    }

    public Transaction(NetworkParameters params, int version, Sha256Hash hash) {
        super(params);
        this.version = (long)version & 0xFFFFFFFFL;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.hash = hash;
        this.length = 8;
    }

    public Transaction(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public Transaction(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
    }

    public Transaction(NetworkParameters params, byte[] msg, int offset, Message parent, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, msg, offset, parent, parseLazy, parseRetain, length);
    }

    public Transaction(NetworkParameters params, byte[] msg, Message parent, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, msg, 0, parent, parseLazy, parseRetain, length);
    }

    @Override
    public Sha256Hash getHash() {
        if (this.hash == null) {
            byte[] bits = this.bitcoinSerialize();
            this.hash = new Sha256Hash(Utils.reverseBytes(Utils.doubleDigest(bits)));
        }
        return this.hash;
    }

    void setHash(Sha256Hash hash) {
        this.hash = hash;
    }

    public String getHashAsString() {
        return this.getHash().toString();
    }

    BigInteger getValueSentToMe(Wallet wallet, boolean includeSpent) {
        this.maybeParse();
        BigInteger v = BigInteger.ZERO;
        for (TransactionOutput o : this.outputs) {
            if (!o.isMine(wallet) || !includeSpent && !o.isAvailableForSpending()) continue;
            v = v.add(o.getValue());
        }
        return v;
    }

    boolean isConsistent(Wallet wallet, boolean isSpent) {
        boolean isActuallySpent = true;
        for (TransactionOutput o : this.outputs) {
            if (o.isAvailableForSpending()) {
                if (o.isMine(wallet)) {
                    isActuallySpent = false;
                }
                if (o.getSpentBy() == null) continue;
                log.error("isAvailableForSpending != spentBy");
                return false;
            }
            if (o.getSpentBy() != null) continue;
            log.error("isAvailableForSpending != spentBy");
            return false;
        }
        return isActuallySpent == isSpent;
    }

    public BigInteger getValueSentToMe(Wallet wallet) {
        return this.getValueSentToMe(wallet, true);
    }

    public Collection<Sha256Hash> getAppearsInHashes() {
        if (this.appearsInHashes != null) {
            return this.appearsInHashes;
        }
        if (this.appearsIn != null) {
            log.info("Migrating a tx to appearsInHashes");
            this.appearsInHashes = new HashSet<Sha256Hash>(this.appearsIn.size());
            for (StoredBlock block : this.appearsIn) {
                this.appearsInHashes.add(block.getHeader().getHash());
            }
            this.appearsIn = null;
        }
        return this.appearsInHashes;
    }

    public boolean isPending() {
        return this.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.NOT_SEEN_IN_CHAIN;
    }

    public void setBlockAppearance(StoredBlock block, boolean bestChain) {
        long blockTime = block.getHeader().getTimeSeconds() * 1000L;
        if (bestChain && (this.updatedAt == null || this.updatedAt.getTime() == 0L || this.updatedAt.getTime() > blockTime)) {
            this.updatedAt = new Date(blockTime);
        }
        this.addBlockAppearance(block.getHeader().getHash());
        if (bestChain) {
            TransactionConfidence transactionConfidence = this.getConfidence();
            transactionConfidence.setAppearedAtChainHeight(block.getHeight());
            transactionConfidence.setDepthInBlocks(1);
            try {
                transactionConfidence.setWorkDone(block.getHeader().getWork());
            }
            catch (VerificationException e) {
                throw new RuntimeException(e);
            }
            transactionConfidence.setConfidenceType(TransactionConfidence.ConfidenceType.BUILDING);
        }
    }

    public void addBlockAppearance(Sha256Hash blockHash) {
        if (this.appearsInHashes == null) {
            this.appearsInHashes = new HashSet<Sha256Hash>();
        }
        this.appearsInHashes.add(blockHash);
    }

    void notifyNotOnBestChain() {
        TransactionConfidence transactionConfidence = this.getConfidence();
        transactionConfidence.setConfidenceType(TransactionConfidence.ConfidenceType.NOT_IN_BEST_CHAIN);
        transactionConfidence.setDepthInBlocks(0);
        transactionConfidence.setWorkDone(BigInteger.ZERO);
    }

    public BigInteger getValueSentFromMe(Wallet wallet) throws ScriptException {
        this.maybeParse();
        BigInteger v = BigInteger.ZERO;
        for (TransactionInput input : this.inputs) {
            TransactionOutput connected = input.getConnectedOutput(wallet.unspent);
            if (connected == null) {
                connected = input.getConnectedOutput(wallet.spent);
            }
            if (connected == null) {
                connected = input.getConnectedOutput(wallet.pending);
            }
            if (connected == null || !connected.isMine(wallet)) continue;
            v = v.add(connected.getValue());
        }
        return v;
    }

    public BigInteger getValue(Wallet wallet) throws ScriptException {
        return this.getValueSentToMe(wallet).subtract(this.getValueSentFromMe(wallet));
    }

    boolean disconnectInputs() {
        boolean disconnected = false;
        this.maybeParse();
        for (TransactionInput input : this.inputs) {
            disconnected |= input.disconnect();
        }
        return disconnected;
    }

    TransactionInput connectForReorganize(Map<Sha256Hash, Transaction> transactions) {
        this.maybeParse();
        for (TransactionInput input : this.inputs) {
            TransactionInput.ConnectionResult result;
            if (input.isCoinBase() || (result = input.connect(transactions, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.SUCCESS || result == TransactionInput.ConnectionResult.NO_SUCH_TX) continue;
            return input;
        }
        return null;
    }

    public boolean isEveryOutputSpent() {
        this.maybeParse();
        for (TransactionOutput output : this.outputs) {
            if (!output.isAvailableForSpending()) continue;
            return false;
        }
        return true;
    }

    public boolean isEveryOwnedOutputSpent(Wallet wallet) {
        this.maybeParse();
        for (TransactionOutput output : this.outputs) {
            if (!output.isAvailableForSpending() || !output.isMine(wallet)) continue;
            return false;
        }
        return true;
    }

    public Date getUpdateTime() {
        if (this.updatedAt == null) {
            this.updatedAt = new Date(0L);
        }
        return this.updatedAt;
    }

    public void setUpdateTime(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    protected void unCache() {
        super.unCache();
        this.hash = null;
    }

    @Override
    protected void parseLite() throws ProtocolException {
        if (this.parseLazy && this.length == Integer.MIN_VALUE) {
            this.length = Transaction.calcLength(this.bytes, this.cursor, this.offset);
            this.cursor = this.offset + this.length;
        }
    }

    protected static int calcLength(byte[] buf, int cursor, int offset) {
        long scriptLen;
        cursor = offset + 4;
        VarInt varint = new VarInt(buf, cursor);
        long txInCount = varint.value;
        cursor += varint.getSizeInBytes();
        int i = 0;
        while ((long)i < txInCount) {
            varint = new VarInt(buf, cursor += 36);
            scriptLen = varint.value;
            cursor = (int)((long)cursor + (scriptLen + 4L + (long)varint.getSizeInBytes()));
            ++i;
        }
        varint = new VarInt(buf, cursor);
        long txOutCount = varint.value;
        cursor += varint.getSizeInBytes();
        i = 0;
        while ((long)i < txOutCount) {
            varint = new VarInt(buf, cursor += 8);
            scriptLen = varint.value;
            cursor = (int)((long)cursor + (scriptLen + (long)varint.getSizeInBytes()));
            ++i;
        }
        return cursor - offset + 4;
    }

    @Override
    void parse() throws ProtocolException {
        if (this.parsed) {
            return;
        }
        this.cursor = this.offset;
        this.version = this.readUint32();
        long numInputs = this.readVarInt();
        this.inputs = new ArrayList((int)numInputs);
        for (long i = 0L; i < numInputs; ++i) {
            TransactionInput input = new TransactionInput(this.params, this, this.bytes, this.cursor, this.parseLazy, this.parseRetain);
            this.inputs.add(input);
            this.cursor += input.getMessageSize();
        }
        long numOutputs = this.readVarInt();
        this.outputs = new ArrayList((int)numOutputs);
        for (long i = 0L; i < numOutputs; ++i) {
            TransactionOutput output = new TransactionOutput(this.params, this, this.bytes, this.cursor, this.parseLazy, this.parseRetain);
            this.outputs.add(output);
            this.cursor += output.getMessageSize();
        }
        this.lockTime = this.readUint32();
        this.length = this.cursor - this.offset;
    }

    public boolean isCoinBase() {
        this.maybeParse();
        return this.inputs.size() == 1 && this.inputs.get(0).isCoinBase();
    }

    public boolean isMature() {
        if (!this.isCoinBase()) {
            return true;
        }
        if (this.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
            return false;
        }
        return this.getConfidence().getDepthInBlocks() >= this.params.getSpendableCoinbaseDepth();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(String.format("  %s: %s%n", this.getHashAsString(), this.getConfidence()));
        if (this.inputs.size() == 0) {
            s.append(String.format("  INCOMPLETE: No inputs!%n", new Object[0]));
            return s.toString();
        }
        if (this.isCoinBase()) {
            String script2;
            String script;
            try {
                script = this.inputs.get(0).getScriptSig().toString();
                script2 = this.outputs.get(0).getScriptPubKey().toString();
            }
            catch (ScriptException e) {
                script = "???";
                script2 = "???";
            }
            return "     == COINBASE TXN (scriptSig " + script + ")  (scriptPubKey " + script2 + ")\n";
        }
        for (TransactionInput in : this.inputs) {
            s.append("     ");
            s.append("from ");
            try {
                Script scriptSig = in.getScriptSig();
                if (scriptSig.chunks.size() == 2) {
                    s.append(scriptSig.getFromAddress().toString());
                } else if (scriptSig.chunks.size() == 1) {
                    s.append("[sig:" + Utils.bytesToHexString(scriptSig.getPubKey()) + "]");
                } else {
                    s.append("???");
                }
                s.append(" / ");
                s.append(in.getOutpoint().toString());
            }
            catch (Exception e) {
                s.append("[exception: ").append(e.getMessage()).append("]");
            }
            s.append(String.format("%n", new Object[0]));
        }
        for (TransactionOutput out : this.outputs) {
            s.append("       ");
            s.append("to ");
            try {
                Script scriptPubKey = out.getScriptPubKey();
                if (scriptPubKey.isSentToAddress()) {
                    s.append(scriptPubKey.getToAddress().toString());
                } else if (scriptPubKey.isSentToRawPubKey()) {
                    s.append("[pubkey:");
                    s.append(Utils.bytesToHexString(scriptPubKey.getPubKey()));
                    s.append("]");
                }
                s.append(" ");
                s.append(Utils.bitcoinValueToFriendlyString(out.getValue()));
                s.append(" BTC");
                if (!out.isAvailableForSpending()) {
                    s.append(" Spent");
                }
                if (out.getSpentBy() != null) {
                    s.append(" by ");
                    s.append(out.getSpentBy().getParentTransaction().getHashAsString());
                }
            }
            catch (Exception e) {
                s.append("[exception: ").append(e.getMessage()).append("]");
            }
            s.append(String.format("%n", new Object[0]));
        }
        return s.toString();
    }

    public void addInput(TransactionOutput from) {
        this.addInput(new TransactionInput(this.params, this, from));
    }

    public void addInput(TransactionInput input) {
        this.unCache();
        input.setParent(this);
        this.inputs.add(input);
        this.adjustLength(this.inputs.size(), input.length);
    }

    public void addOutput(TransactionOutput to) {
        this.unCache();
        to.setParent(this);
        this.outputs.add(to);
        this.adjustLength(this.outputs.size(), to.length);
    }

    public void addOutput(BigInteger value, Address address) {
        this.addOutput(new TransactionOutput(this.params, this, value, address));
    }

    public void addOutput(BigInteger value, ECKey pubkey) {
        this.addOutput(new TransactionOutput(this.params, this, value, pubkey));
    }

    public synchronized void signInputs(SigHash hashType, Wallet wallet) throws ScriptException {
        ECKey key;
        TransactionInput input;
        int i;
        Preconditions.checkState(this.inputs.size() > 0);
        Preconditions.checkState(this.outputs.size() > 0);
        Preconditions.checkArgument(hashType == SigHash.ALL, "Only SIGHASH_ALL is currently supported");
        byte[][] signatures = new byte[this.inputs.size()][];
        ECKey[] signingKeys = new ECKey[this.inputs.size()];
        for (i = 0; i < this.inputs.size(); ++i) {
            input = this.inputs.get(i);
            Preconditions.checkState(input.getScriptBytes().length == 0, "Attempting to sign a non-fresh transaction");
            key = input.getOutpoint().getConnectedKey(wallet);
            Preconditions.checkNotNull(key, "Transaction exists in wallet that we cannot redeem: %s", input.getOutpoint().getHash());
            signingKeys[i] = key;
            boolean anyoneCanPay = false;
            byte[] connectedPubKeyScript = input.getOutpoint().getConnectedPubKeyScript();
            Sha256Hash hash = this.hashTransactionForSignature(i, connectedPubKeyScript, hashType, anyoneCanPay);
            try {
                UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(73);
                bos.write(key.sign(hash.getBytes()));
                ((ByteArrayOutputStream)bos).write(hashType.ordinal() + 1 | (anyoneCanPay ? 128 : 0));
                signatures[i] = ((ByteArrayOutputStream)bos).toByteArray();
                bos.close();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            input = this.inputs.get(i);
            Preconditions.checkState(input.getScriptBytes().length == 0);
            key = signingKeys[i];
            Script scriptPubKey = input.getOutpoint().getConnectedOutput().getScriptPubKey();
            if (scriptPubKey.isSentToAddress()) {
                input.setScriptBytes(Script.createInputScript(signatures[i], key.getPubKey()));
                continue;
            }
            if (scriptPubKey.isSentToRawPubKey()) {
                input.setScriptBytes(Script.createInputScript(signatures[i]));
                continue;
            }
            throw new RuntimeException("Do not understand script type: " + scriptPubKey);
        }
    }

    public synchronized Sha256Hash hashTransactionForSignature(int inputIndex, byte[] connectedScript, SigHash type, boolean anyoneCanPay) {
        try {
            byte[][] scripts = new byte[this.inputs.size()][];
            for (int i = 0; i < this.inputs.size(); ++i) {
                scripts[i] = this.inputs.get(i).getScriptBytes();
                this.inputs.get(i).setScriptBytes(TransactionInput.EMPTY_ARRAY);
            }
            TransactionInput input = this.inputs.get(inputIndex);
            input.setScriptBytes(connectedScript);
            UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(this.length == Integer.MIN_VALUE ? 256 : this.length + 4);
            this.bitcoinSerialize(bos);
            int hashType = type.ordinal() + 1;
            if (anyoneCanPay) {
                hashType |= 0x80;
            }
            Utils.uint32ToByteStreamLE(hashType, bos);
            Sha256Hash hash = new Sha256Hash(Utils.doubleDigest(((ByteArrayOutputStream)bos).toByteArray()));
            bos.close();
            for (int i = 0; i < this.inputs.size(); ++i) {
                this.inputs.get(i).setScriptBytes(scripts[i]);
            }
            return hash;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.uint32ToByteStreamLE(this.version, stream);
        stream.write(new VarInt(this.inputs.size()).encode());
        for (TransactionInput in : this.inputs) {
            in.bitcoinSerialize(stream);
        }
        stream.write(new VarInt(this.outputs.size()).encode());
        for (TransactionOutput out : this.outputs) {
            out.bitcoinSerialize(stream);
        }
        Utils.uint32ToByteStreamLE(this.lockTime, stream);
    }

    public long getLockTime() {
        this.maybeParse();
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.unCache();
        this.lockTime = lockTime;
    }

    public long getVersion() {
        this.maybeParse();
        return this.version;
    }

    public List<TransactionInput> getInputs() {
        this.maybeParse();
        return Collections.unmodifiableList(this.inputs);
    }

    public List<TransactionOutput> getOutputs() {
        this.maybeParse();
        return Collections.unmodifiableList(this.outputs);
    }

    public synchronized TransactionConfidence getConfidence() {
        if (this.confidence == null) {
            this.confidence = new TransactionConfidence(this);
        }
        return this.confidence;
    }

    public synchronized boolean hasConfidence() {
        return this.confidence != null && this.confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.UNKNOWN;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Transaction)) {
            return false;
        }
        Transaction t = (Transaction)other;
        return t.getHash().equals(this.getHash());
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SigHash {
        ALL,
        NONE,
        SINGLE;

    }
}

