/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionOutPoint;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionInput
extends ChildMessage
implements Serializable {
    public static final long NO_SEQUENCE = 0xFFFFFFFFL;
    private static final long serialVersionUID = 2L;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private long sequence;
    private TransactionOutPoint outpoint;
    private byte[] scriptBytes;
    private transient Script scriptSig;
    private Transaction parentTransaction;

    TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] scriptBytes) {
        super(params);
        this.scriptBytes = scriptBytes;
        this.outpoint = new TransactionOutPoint(params, 0xFFFFFFFFL, (Transaction)null);
        this.sequence = 0xFFFFFFFFL;
        this.parentTransaction = parentTransaction;
        this.length = 40 + (scriptBytes == null ? 1 : VarInt.sizeOf(scriptBytes.length) + scriptBytes.length);
    }

    public TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint) {
        super(params);
        this.scriptBytes = scriptBytes;
        this.outpoint = outpoint;
        this.sequence = 0xFFFFFFFFL;
        this.parentTransaction = parentTransaction;
        this.length = 40 + (scriptBytes == null ? 1 : VarInt.sizeOf(scriptBytes.length) + scriptBytes.length);
    }

    TransactionInput(NetworkParameters params, Transaction parentTransaction, TransactionOutput output) {
        super(params);
        long outputIndex = output.getIndex();
        this.outpoint = new TransactionOutPoint(params, outputIndex, output.parentTransaction);
        this.scriptBytes = EMPTY_ARRAY;
        this.sequence = 0xFFFFFFFFL;
        this.parentTransaction = parentTransaction;
        this.length = 41;
    }

    public TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.parentTransaction = parentTransaction;
    }

    public TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] msg, int offset, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, msg, offset, parentTransaction, parseLazy, parseRetain, Integer.MIN_VALUE);
        this.parentTransaction = parentTransaction;
    }

    @Override
    protected void parseLite() {
        int curs = this.cursor;
        int scriptLen = (int)this.readVarInt(36);
        this.length = this.cursor - this.offset + scriptLen + 4;
        this.cursor = curs;
    }

    @Override
    void parse() throws ProtocolException {
        this.outpoint = new TransactionOutPoint(this.params, this.bytes, this.cursor, this, this.parseLazy, this.parseRetain);
        this.cursor += this.outpoint.getMessageSize();
        int scriptLen = (int)this.readVarInt();
        this.scriptBytes = this.readBytes(scriptLen);
        this.sequence = this.readUint32();
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        this.outpoint.bitcoinSerialize(stream);
        stream.write(new VarInt(this.scriptBytes.length).encode());
        stream.write(this.scriptBytes);
        Utils.uint32ToByteStreamLE(this.sequence, stream);
    }

    public boolean isCoinBase() {
        this.maybeParse();
        return this.outpoint.getHash().equals(Sha256Hash.ZERO_HASH) && this.outpoint.getIndex() == 0xFFFFFFFFL;
    }

    public Script getScriptSig() throws ScriptException {
        if (this.scriptSig == null) {
            this.maybeParse();
            this.scriptSig = new Script(this.params, Preconditions.checkNotNull(this.scriptBytes), 0, this.scriptBytes.length);
        }
        return this.scriptSig;
    }

    public Address getFromAddress() throws ScriptException {
        if (this.isCoinBase()) {
            throw new ScriptException("This is a coinbase transaction which generates new coins. It does not have a from address.");
        }
        return this.getScriptSig().getFromAddress();
    }

    public long getSequence() {
        this.maybeParse();
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.unCache();
        this.sequence = sequence;
    }

    public TransactionOutPoint getOutpoint() {
        this.maybeParse();
        return this.outpoint;
    }

    public byte[] getScriptBytes() {
        this.maybeParse();
        return this.scriptBytes;
    }

    void setScriptBytes(byte[] scriptBytes) {
        this.unCache();
        int oldLength = this.length;
        this.scriptBytes = scriptBytes;
        int newLength = 40 + (scriptBytes == null ? 1 : VarInt.sizeOf(scriptBytes.length) + scriptBytes.length);
        this.adjustLength(newLength - oldLength);
    }

    public Transaction getParentTransaction() {
        return this.parentTransaction;
    }

    public String toString() {
        if (this.isCoinBase()) {
            return "TxIn: COINBASE";
        }
        try {
            return "TxIn from tx " + this.outpoint + " (pubkey: " + Utils.bytesToHexString(this.getScriptSig().getPubKey()) + ") script:" + this.getScriptSig().toString();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    TransactionOutput getConnectedOutput(Map<Sha256Hash, Transaction> transactions) {
        Transaction tx = transactions.get(this.outpoint.getHash());
        if (tx == null) {
            return null;
        }
        TransactionOutput out = tx.getOutputs().get((int)this.outpoint.getIndex());
        return out;
    }

    ConnectionResult connect(Map<Sha256Hash, Transaction> transactions, ConnectMode mode) {
        Transaction tx = transactions.get(this.outpoint.getHash());
        if (tx == null) {
            return ConnectionResult.NO_SUCH_TX;
        }
        TransactionOutput out = tx.getOutputs().get((int)this.outpoint.getIndex());
        if (!out.isAvailableForSpending()) {
            if (mode == ConnectMode.DISCONNECT_ON_CONFLICT) {
                out.markAsUnspent();
            } else if (mode == ConnectMode.ABORT_ON_CONFLICT) {
                this.outpoint.fromTx = Preconditions.checkNotNull(out.parentTransaction);
                return ConnectionResult.ALREADY_SPENT;
            }
        }
        this.connect(out);
        return ConnectionResult.SUCCESS;
    }

    public void connect(TransactionOutput out) {
        this.outpoint.fromTx = Preconditions.checkNotNull(out.parentTransaction);
        out.markAsSpent(this);
    }

    boolean disconnect() {
        if (this.outpoint.fromTx == null) {
            return false;
        }
        this.outpoint.fromTx.getOutputs().get((int)this.outpoint.getIndex()).markAsUnspent();
        this.outpoint.fromTx = null;
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }

    public boolean hasSequence() {
        return this.sequence != 0xFFFFFFFFL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConnectMode {
        DISCONNECT_ON_CONFLICT,
        ABORT_ON_CONFLICT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConnectionResult {
        NO_SUCH_TX,
        ALREADY_SPENT,
        SUCCESS;

    }
}

