/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.NetworkParameters;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import sockthing.AddressDifficultyAuthHandler;
import sockthing.AuthHandler;
import sockthing.BitcoinRPC;
import sockthing.Config;
import sockthing.DBShareSaver;
import sockthing.PoolUser;
import sockthing.ShareSaver;
import sockthing.StratumConnection;
import sockthing.UserSessionData;

public class StratumServer
extends Thread {
    private int port = 3333;
    private BitcoinRPC bitcoin_rpc;
    private long max_idle_time = 300000000000L;
    private Map<String, StratumConnection> conn_map = new HashMap<String, StratumConnection>(1024, 0.5f);
    private Config config;
    private AuthHandler auth_handler;
    private Address pay_to_address;
    private NetworkParameters network_params;
    private ShareSaver share_saver;
    private JSONObject cached_block_template;
    private Map<String, UserSessionData> user_session_data_map = new HashMap<String, UserSessionData>(1024, 0.5f);
    private volatile int current_block;
    private volatile long current_block_update_time;

    public StratumServer(Config config) {
        this.config = config;
        config.require("port");
        this.port = config.getInt("port");
        this.bitcoin_rpc = new BitcoinRPC(config);
    }

    public void setAuthHandler(AuthHandler auth_handler) {
        this.auth_handler = auth_handler;
    }

    public AuthHandler getAuthHandler() {
        return this.auth_handler;
    }

    public void setShareSaver(ShareSaver share_saver) {
        this.share_saver = share_saver;
    }

    public ShareSaver getShareSaver() {
        return this.share_saver;
    }

    public void setPayToAddress(Address addr) {
        this.pay_to_address = addr;
    }

    public Address getPayToAddress() {
        return this.pay_to_address;
    }

    public NetworkParameters getNetworkParameters() {
        return this.network_params;
    }

    public void setNetworkParameters(NetworkParameters network_params) {
        this.network_params = network_params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ServerSocket ss = new ServerSocket(this.port, 256);
            ss.setReuseAddress(true);
            new TimeoutThread().start();
            new NewBlockThread().start();
            while (ss.isBound()) {
                try {
                    Socket sock = ss.accept();
                    String id = UUID.randomUUID().toString();
                    StratumConnection conn = new StratumConnection(this, sock, id);
                    Map<String, StratumConnection> map = this.conn_map;
                    synchronized (map) {
                        this.conn_map.put(id, conn);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int checkStale(int next_block) {
        if (next_block == this.current_block + 1) {
            return 0;
        }
        if (next_block == this.current_block + 2 && this.current_block_update_time + 10000L > System.currentTimeMillis()) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerUpdate(boolean clean) throws Exception {
        System.out.println("Update triggered. Clean: " + clean);
        this.cached_block_template = null;
        JSONObject block_template = this.getCurrentBlockTemplate();
        LinkedList<Map.Entry<String, StratumConnection>> lst = new LinkedList<Map.Entry<String, StratumConnection>>();
        Map<String, StratumConnection> map = this.conn_map;
        synchronized (map) {
            lst.addAll(this.conn_map.entrySet());
        }
        for (Map.Entry entry : lst) {
            ((StratumConnection)entry.getValue()).sendRealJob(block_template, clean);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Expected exactly one argument, a config file");
            System.out.println("java -jar SockThing.jar pool.cfg");
            return;
        }
        Config conf = new Config(args[0]);
        conf.require("pay_to_address");
        conf.require("network");
        StratumServer server = new StratumServer(conf);
        server.setAuthHandler(new AddressDifficultyAuthHandler(conf));
        server.setShareSaver(new DBShareSaver(conf));
        String network = conf.get("network");
        if (network.equals("prodnet")) {
            server.setNetworkParameters(NetworkParameters.prodNet());
        } else if (network.equals("testnet")) {
            server.setNetworkParameters(NetworkParameters.testNet3());
        }
        server.setPayToAddress(new Address(server.getNetworkParameters(), conf.get("pay_to_address")));
        server.start();
    }

    public JSONObject getCurrentBlockTemplate() throws IOException, JSONException {
        JSONObject c = this.cached_block_template;
        if (c != null) {
            return c;
        }
        JSONObject post = new JSONObject(BitcoinRPC.getSimplePostRequest("getblocktemplate"));
        this.cached_block_template = c = this.bitcoin_rpc.sendPost(post).getJSONObject("result");
        return c;
    }

    public String submitBlock(Block blk) {
        try {
            JSONObject result = this.bitcoin_rpc.submitBlock(blk);
            System.out.println(result.toString(2));
            return "Y";
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "N";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSessionData getUserSessionData(PoolUser pu) {
        Map<String, UserSessionData> map = this.user_session_data_map;
        synchronized (map) {
            UserSessionData ud = this.user_session_data_map.get(pu.getWorkerName());
            if (ud == null) {
                ud = new UserSessionData();
            }
            this.user_session_data_map.put(pu.getWorkerName(), ud);
            return ud;
        }
    }

    public class NewBlockThread
    extends Thread {
        int last_block;
        long last_update_time;

        public NewBlockThread() {
            this.setDaemon(true);
            this.last_update_time = System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        this.doRun();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void doRun() throws Exception {
            JSONObject reply = StratumServer.this.bitcoin_rpc.doSimplePostRequest("getblockcount");
            int block_height = reply.getInt("result");
            if (block_height != this.last_block) {
                System.out.println(reply);
                StratumServer.this.triggerUpdate(true);
                this.last_block = block_height;
                this.last_update_time = System.currentTimeMillis();
                StratumServer.this.current_block_update_time = System.currentTimeMillis();
                StratumServer.this.current_block = block_height;
            }
            if (this.last_update_time + 30000L < System.currentTimeMillis()) {
                StratumServer.this.triggerUpdate(false);
                this.last_update_time = System.currentTimeMillis();
            }
        }
    }

    public class TimeoutThread
    extends Thread {
        public TimeoutThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LinkedList lst = new LinkedList();
                Map map = StratumServer.this.conn_map;
                synchronized (map) {
                    lst.addAll(StratumServer.this.conn_map.entrySet());
                }
                for (Map.Entry entry : lst) {
                    if (((StratumConnection)entry.getValue()).getLastNetworkAction() + StratumServer.this.max_idle_time >= System.nanoTime()) continue;
                    System.out.println("Closing connection due to inactivity: " + (String)entry.getKey());
                    ((StratumConnection)entry.getValue()).close();
                    Map map2 = StratumServer.this.conn_map;
                    synchronized (map2) {
                        StratumServer.this.conn_map.remove(entry.getKey());
                    }
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

