/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.UUID;

public class TCPRecorder {
    public static void main(String[] args) throws Exception {
        String dir = args[0];
        String host = args[1];
        int port = Integer.parseInt(args[2]);
        int local_port = Integer.parseInt(args[3]);
        new TCPRecorder(dir, host, port, local_port);
    }

    public TCPRecorder(String log_dir, String remote_host, int remote_port, int local_port) throws Exception {
        ServerSocket ss = new ServerSocket(local_port);
        ss.setReuseAddress(true);
        while (ss.isBound()) {
            try {
                Socket s = ss.accept();
                Socket remote_s = new Socket(remote_host, remote_port);
                ConnectionContext ctx = new ConnectionContext(log_dir, s, remote_s);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class ReaderThread
    extends Thread {
        ConnectionContext ctx;
        Socket read_socket;
        Socket write_socket;
        String side;

        public ReaderThread(ConnectionContext ctx, Socket read_socket, Socket write_socket, String side) {
            this.ctx = ctx;
            this.read_socket = read_socket;
            this.write_socket = write_socket;
            this.side = side;
        }

        @Override
        public void run() {
            try {
                InputStream in = this.read_socket.getInputStream();
                OutputStream out = this.write_socket.getOutputStream();
                byte[] buff = new byte[65536];
                while (this.ctx.open) {
                    int sz = in.read(buff);
                    if (sz < 0) {
                        this.ctx.close();
                        return;
                    }
                    this.ctx.log(buff, 0, sz, this.side);
                    out.write(buff, 0, sz);
                }
            }
            catch (Throwable t) {
                this.ctx.close();
            }
        }
    }

    public class ConnectionContext {
        public Socket local_sock;
        public Socket remote_sock;
        public ReaderThread local_reader;
        public ReaderThread remote_reader;
        public volatile boolean open;
        private PrintStream log_out;

        public ConnectionContext(String log_dir, Socket local, Socket remote) throws Exception {
            this.local_sock = local;
            this.remote_sock = remote;
            String log_file = log_dir + "/" + UUID.randomUUID().toString() + ".txt";
            System.out.println("Starting connection: " + log_file);
            this.log_out = new PrintStream(new FileOutputStream(log_file));
            this.open = true;
            this.local_reader = new ReaderThread(this, this.local_sock, this.remote_sock, "local");
            this.local_reader.start();
            this.remote_reader = new ReaderThread(this, this.remote_sock, this.local_sock, "remote");
            this.remote_reader.start();
        }

        public void close() {
            this.open = false;
            try {
                this.local_sock.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.remote_sock.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.log_out.flush();
                this.log_out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(byte[] buff, int offset, int size, String side) {
            String str = new String(buff, offset, size);
            PrintStream printStream = this.log_out;
            synchronized (printStream) {
                this.log_out.println("----------------------------");
                this.log_out.println("Side: " + side);
                this.log_out.println(str);
            }
        }
    }
}

