/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspendProcessesRequest
extends AmazonWebServiceRequest {
    private String autoScalingGroupName;
    private List<String> scalingProcesses;

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public SuspendProcessesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public List<String> getScalingProcesses() {
        if (this.scalingProcesses == null) {
            this.scalingProcesses = new ArrayList<String>();
        }
        return this.scalingProcesses;
    }

    public void setScalingProcesses(Collection<String> scalingProcesses) {
        if (scalingProcesses == null) {
            this.scalingProcesses = null;
            return;
        }
        ArrayList<String> scalingProcessesCopy = new ArrayList<String>(scalingProcesses.size());
        scalingProcessesCopy.addAll(scalingProcesses);
        this.scalingProcesses = scalingProcessesCopy;
    }

    public SuspendProcessesRequest withScalingProcesses(String ... scalingProcesses) {
        if (this.getScalingProcesses() == null) {
            this.setScalingProcesses(new ArrayList<String>(scalingProcesses.length));
        }
        for (String value : scalingProcesses) {
            this.getScalingProcesses().add(value);
        }
        return this;
    }

    public SuspendProcessesRequest withScalingProcesses(Collection<String> scalingProcesses) {
        if (scalingProcesses == null) {
            this.scalingProcesses = null;
        } else {
            ArrayList<String> scalingProcessesCopy = new ArrayList<String>(scalingProcesses.size());
            scalingProcessesCopy.addAll(scalingProcesses);
            this.scalingProcesses = scalingProcessesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ", ");
        }
        if (this.getScalingProcesses() != null) {
            sb.append("ScalingProcesses: " + this.getScalingProcesses() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getScalingProcesses() == null ? 0 : ((Object)this.getScalingProcesses()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest)obj;
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getScalingProcesses() == null ^ this.getScalingProcesses() == null) {
            return false;
        }
        return other.getScalingProcesses() == null || ((Object)other.getScalingProcesses()).equals(this.getScalingProcesses());
    }
}

