/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.VersionedChecksummedBytes;
import com.google.bitcoin.core.WrongNetworkException;

public class Address
extends VersionedChecksummedBytes {
    public static final int LENGTH = 20;

    public Address(NetworkParameters params, byte[] hash160) {
        super(params.addressHeader, hash160);
        if (hash160.length != 20) {
            throw new RuntimeException("Addresses are 160-bit hashes, so you must provide 20 bytes");
        }
    }

    public Address(NetworkParameters params, String address) throws AddressFormatException, WrongNetworkException {
        super(address);
        if (params != null) {
            boolean found = false;
            for (int v : params.acceptableAddressCodes) {
                if (this.version != v) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new WrongNetworkException(this.version, params.acceptableAddressCodes);
            }
        }
    }

    public byte[] getHash160() {
        return this.bytes;
    }

    public NetworkParameters getParameters() {
        NetworkParameters[] networks;
        for (NetworkParameters params : networks = new NetworkParameters[]{NetworkParameters.testNet(), NetworkParameters.prodNet()}) {
            if (params.acceptableAddressCodes == null) {
                if (params.getId().equals("org.bitcoin.production")) {
                    params = NetworkParameters.prodNet();
                } else if (params.getId().equals("org.bitcoin.test")) {
                    params = NetworkParameters.testNet();
                }
            }
            for (int code : params.acceptableAddressCodes) {
                if (code != this.version) continue;
                return params;
            }
        }
        return null;
    }

    public static NetworkParameters getParametersFromAddress(String address) throws AddressFormatException {
        try {
            return new Address(null, address).getParameters();
        }
        catch (WrongNetworkException e) {
            throw new RuntimeException(e);
        }
    }
}

