/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Random;
import sockthing.PoolUser;
import sockthing.StratumServer;

public class Coinbase {
    Transaction tx;
    byte[] tx_data;
    byte[] script_bytes;
    byte[] extranonce1;
    byte[] extranonce2;
    BigInteger value;
    BigInteger fee_total;
    StratumServer server;
    PoolUser pool_user;
    public static final int BLOCK_HEIGHT_OFF = 0;
    public static final int EXTRA1_OFF = 4;
    public static final int EXTRA2_OFF = 8;
    public static final int RANDOM_OFF = 12;

    public Coinbase(StratumServer server, PoolUser pool_user, int block_height, BigInteger value, BigInteger fee_total, byte[] extranonce1) {
        int i;
        server.getConfig().require("coinbase_text");
        this.server = server;
        this.pool_user = pool_user;
        this.value = value;
        this.fee_total = fee_total;
        this.extranonce1 = extranonce1;
        this.extranonce2 = new byte[4];
        byte[] height_array = new byte[4];
        ByteBuffer bb = ByteBuffer.wrap(height_array);
        bb.putInt(block_height);
        height_array[0] = 3;
        String script = "BLKHEXT1EXT2RNDN/SockThing/" + server.getConfig().get("coinbase_text");
        this.script_bytes = script.getBytes();
        if (this.script_bytes.length > 100) {
            throw new RuntimeException("Script bytes too long for coinbase");
        }
        for (i = 0; i < 4; ++i) {
            this.script_bytes[i + 0] = height_array[i];
        }
        this.script_bytes[1] = height_array[3];
        this.script_bytes[3] = height_array[1];
        for (i = 0; i < 4; ++i) {
            this.script_bytes[i + 4] = extranonce1[i];
        }
        byte[] rand = new byte[4];
        Random rnd = new Random();
        rnd.nextBytes(rand);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.script_bytes[i2 + 12] = rand[i2];
        }
        this.genTx();
    }

    public Transaction genTx() {
        this.tx = new Transaction(this.server.getNetworkParameters());
        this.tx.addInput(new TransactionInput(this.server.getNetworkParameters(), this.tx, this.script_bytes));
        this.server.getOutputMonster().addOutputs(this.pool_user, this.tx, this.value, this.fee_total);
        this.tx_data = this.tx.bitcoinSerialize();
        return this.tx;
    }

    public void setExtranonce2(byte[] extranonce2) {
        for (int i = 0; i < 4; ++i) {
            this.script_bytes[i + 8] = extranonce2[i];
        }
    }

    public byte[] getCoinbase1() {
        int cb1_size = 46;
        byte[] buff = new byte[46];
        for (int i = 0; i < cb1_size; ++i) {
            buff[i] = this.tx_data[i];
        }
        return buff;
    }

    public byte[] getCoinbase2() {
        int sz = this.tx_data.length - 42 - 4 - 8;
        byte[] buff = new byte[sz];
        for (int i = 0; i < sz; ++i) {
            buff[i] = this.tx_data[i + 42 + 8 + 4];
        }
        return buff;
    }
}

