/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.spongycastle.util.encoders.Hex;

public class NetworkParameters
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int PROTOCOL_VERSION = 60001;
    public static final byte[] SATOSHI_KEY = Hex.decode("04fc9702847840aaf195de8442ebecedf5b095cdbb9bc716bda9110971b28a49e0ead8564ff0db22209e0374782c093bb899692d524e9d6a6956e7c5ecbcd68284");
    public static final String ID_PRODNET = "org.bitcoin.production";
    public static final String ID_TESTNET = "org.bitcoin.test";
    public Block genesisBlock;
    public BigInteger proofOfWorkLimit;
    public int port;
    public long packetMagic;
    public int addressHeader;
    public int dumpedPrivateKeyHeader;
    public int interval;
    public int targetTimespan;
    public byte[] alertSigningKey;
    private String id;
    private int spendableCoinbaseDepth;
    public int[] acceptableAddressCodes;
    public static final int TARGET_TIMESPAN = 1209600;
    public static final int TARGET_SPACING = 600;
    public static final int INTERVAL = 2016;

    private static Block createGenesis(NetworkParameters n) {
        Block genesisBlock = new Block(n);
        Transaction t = new Transaction(n);
        try {
            byte[] bytes = Hex.decode("04ffff001d0104455468652054696d65732030332f4a616e2f32303039204368616e63656c6c6f72206f6e206272696e6b206f66207365636f6e64206261696c6f757420666f722062616e6b73");
            t.addInput(new TransactionInput(n, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes(scriptPubKeyBytes, Hex.decode("04678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5f"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(n, t, scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    private static NetworkParameters createTestNet3(NetworkParameters n) {
        n.proofOfWorkLimit = Utils.decodeCompactBits(486604799L);
        n.packetMagic = 185665799L;
        n.port = 18333;
        n.addressHeader = 111;
        n.acceptableAddressCodes = new int[]{111};
        n.dumpedPrivateKeyHeader = 239;
        n.interval = 2016;
        n.targetTimespan = 1209600;
        n.alertSigningKey = SATOSHI_KEY;
        n.genesisBlock = NetworkParameters.createGenesis(n);
        n.genesisBlock.setTime(1296688602L);
        n.genesisBlock.setDifficultyTarget(486604799L);
        n.genesisBlock.setNonce(414098458L);
        n.setSpendableCoinbaseDepth(100);
        n.id = ID_TESTNET;
        String genesisHash = n.genesisBlock.getHashAsString();
        Preconditions.checkState(genesisHash.equals("000000000933ea01ad0ee984209779baaec3ced90fa3f408719526f8d77f4943"), genesisHash);
        return n;
    }

    private static NetworkParameters createTestNet(NetworkParameters n) {
        n.proofOfWorkLimit = Utils.decodeCompactBits(487587839L);
        n.packetMagic = 4206867930L;
        n.port = 18333;
        n.addressHeader = 111;
        n.acceptableAddressCodes = new int[]{111};
        n.dumpedPrivateKeyHeader = 239;
        n.interval = 2016;
        n.targetTimespan = 1209600;
        n.alertSigningKey = SATOSHI_KEY;
        n.genesisBlock = NetworkParameters.createGenesis(n);
        n.genesisBlock.setTime(1296688602L);
        n.genesisBlock.setDifficultyTarget(487063544L);
        n.genesisBlock.setNonce(384568319L);
        n.setSpendableCoinbaseDepth(100);
        n.id = ID_TESTNET;
        String genesisHash = n.genesisBlock.getHashAsString();
        Preconditions.checkState(genesisHash.equals("00000007199508e34a9ff81e6ec0c477a4cccff2a4767a8eee39c11db367b008"), genesisHash);
        return n;
    }

    public static NetworkParameters testNet() {
        NetworkParameters n = new NetworkParameters();
        return NetworkParameters.createTestNet(n);
    }

    public static NetworkParameters testNet3() {
        NetworkParameters n = new NetworkParameters();
        return NetworkParameters.createTestNet3(n);
    }

    public static NetworkParameters prodNet() {
        NetworkParameters n = new NetworkParameters();
        n.proofOfWorkLimit = Utils.decodeCompactBits(486604799L);
        n.port = 8333;
        n.packetMagic = 4190024921L;
        n.addressHeader = 0;
        n.acceptableAddressCodes = new int[]{0};
        n.dumpedPrivateKeyHeader = 128;
        n.interval = 2016;
        n.targetTimespan = 1209600;
        n.alertSigningKey = SATOSHI_KEY;
        n.genesisBlock = NetworkParameters.createGenesis(n);
        n.genesisBlock.setDifficultyTarget(486604799L);
        n.genesisBlock.setTime(1231006505L);
        n.genesisBlock.setNonce(2083236893L);
        n.setSpendableCoinbaseDepth(100);
        n.id = ID_PRODNET;
        String genesisHash = n.genesisBlock.getHashAsString();
        Preconditions.checkState(genesisHash.equals("000000000019d6689c085ae165831e934ff763ae46a2a6c172b3f1b60a8ce26f"), genesisHash);
        return n;
    }

    public static NetworkParameters unitTests() {
        NetworkParameters n = new NetworkParameters();
        n = NetworkParameters.createTestNet(n);
        n.proofOfWorkLimit = new BigInteger("00ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", 16);
        n.genesisBlock.setTime(System.currentTimeMillis() / 1000L);
        n.genesisBlock.setDifficultyTarget(545259519L);
        n.genesisBlock.solve();
        n.interval = 10;
        n.targetTimespan = 200000000;
        n.setSpendableCoinbaseDepth(5);
        n.id = "com.google.bitcoin.unittest";
        return n;
    }

    public String getId() {
        if (this.id == null) {
            if (this.port == 8333) {
                this.id = ID_PRODNET;
            } else if (this.port == 18333) {
                this.id = ID_TESTNET;
            }
        }
        return this.id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof NetworkParameters)) {
            return false;
        }
        NetworkParameters o = (NetworkParameters)other;
        return o.getId().equals(this.getId());
    }

    public static NetworkParameters fromID(String id) {
        if (id.equals(ID_PRODNET)) {
            return NetworkParameters.prodNet();
        }
        if (id.equals(ID_TESTNET)) {
            return NetworkParameters.testNet();
        }
        return null;
    }

    public int getSpendableCoinbaseDepth() {
        return this.spendableCoinbaseDepth;
    }

    public void setSpendableCoinbaseDepth(int coinbaseDepth) {
        this.spendableCoinbaseDepth = coinbaseDepth;
    }
}

