/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressMessage;
import com.google.bitcoin.core.AlertMessage;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.GetBlocksMessage;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.GetHeadersMessage;
import com.google.bitcoin.core.HeadersMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.MemoryPool;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.Ping;
import com.google.bitcoin.core.Pong;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.VersionAck;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.utils.EventListenerInvoker;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Peer {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    private final NetworkParameters params;
    private final BlockChain blockChain;
    private final List<GetDataFuture<Block>> pendingGetBlockFutures;
    private PeerAddress address;
    private List<PeerEventListener> eventListeners;
    private List<PeerLifecycleListener> lifecycleListeners;
    private boolean downloadData = true;
    private VersionMessage versionMessage;
    private MemoryPool memoryPool;
    private long fastCatchupTimeSecs;
    private boolean downloadBlockBodies = true;
    private HashSet<Sha256Hash> pendingBlockDownloads = new HashSet();
    private Channel channel;
    private VersionMessage peerVersionMessage;
    boolean isAcked;
    private PeerHandler handler;
    private Sha256Hash lastGetBlocksBegin;
    private Sha256Hash lastGetBlocksEnd;

    public Peer(NetworkParameters params, BlockChain blockChain, VersionMessage ver) {
        this.params = params;
        this.blockChain = blockChain;
        this.versionMessage = ver;
        this.pendingGetBlockFutures = new ArrayList<GetDataFuture<Block>>();
        this.eventListeners = new CopyOnWriteArrayList<PeerEventListener>();
        this.lifecycleListeners = new CopyOnWriteArrayList<PeerLifecycleListener>();
        this.fastCatchupTimeSecs = params.genesisBlock.getTimeSeconds();
        this.isAcked = false;
        this.handler = new PeerHandler();
    }

    public Peer(NetworkParameters params, BlockChain blockChain, String thisSoftwareName, String thisSoftwareVersion) {
        this(params, blockChain, null);
        this.versionMessage = new VersionMessage(params, blockChain.getBestChainHeight());
        this.versionMessage.appendToSubVer(thisSoftwareName, thisSoftwareVersion, null);
    }

    public synchronized void addEventListener(PeerEventListener listener) {
        this.eventListeners.add(listener);
    }

    public synchronized boolean removeEventListener(PeerEventListener listener) {
        return this.eventListeners.remove(listener);
    }

    synchronized void addLifecycleListener(PeerLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    synchronized boolean removeLifecycleListener(PeerLifecycleListener listener) {
        return this.lifecycleListeners.remove(listener);
    }

    public synchronized void setMemoryPool(MemoryPool pool) {
        this.memoryPool = pool;
    }

    public String toString() {
        if (this.address == null) {
            return "Peer()";
        }
        return "Peer(" + this.address.getAddr() + ":" + this.address.getPort() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDisconnect() {
        Iterator<PeerLifecycleListener> i$ = this.lifecycleListeners.iterator();
        while (i$.hasNext()) {
            PeerLifecycleListener listener;
            PeerLifecycleListener peerLifecycleListener = listener = i$.next();
            synchronized (peerLifecycleListener) {
                listener.onPeerDisconnected(this);
            }
        }
    }

    private void processAlert(AlertMessage m) {
        try {
            if (m.isSignatureValid()) {
                log.info("Received alert from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
            } else {
                log.warn("Received alert with invalid signature from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
            }
        }
        catch (Throwable t) {
            log.error("Failed to check signature: bug in platform libraries?", t);
        }
    }

    public PeerHandler getHandler() {
        return this.handler;
    }

    private void processHeaders(HeadersMessage m) throws IOException, ProtocolException {
        Preconditions.checkState(!this.downloadBlockBodies, this.toString());
        try {
            for (int i = 0; i < m.getBlockHeaders().size(); ++i) {
                Block header = m.getBlockHeaders().get(i);
                if (header.getTimeSeconds() < this.fastCatchupTimeSecs) {
                    if (!this.blockChain.add(header)) {
                        throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                    }
                } else {
                    log.info("Passed the fast catchup time, discarding {} headers and requesting full blocks", m.getBlockHeaders().size() - i);
                    this.downloadBlockBodies = true;
                    this.lastGetBlocksBegin = Sha256Hash.ZERO_HASH;
                    this.blockChainDownload(Sha256Hash.ZERO_HASH);
                    return;
                }
                this.invokeOnBlocksDownloaded(header);
            }
            if (m.getBlockHeaders().size() >= 2000) {
                this.blockChainDownload(Sha256Hash.ZERO_HASH);
            }
        }
        catch (VerificationException e) {
            log.warn("Block header verification failed", e);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processGetData(GetDataMessage getdata) throws IOException {
        log.info("{}: Received getdata message: {}", this.address, (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        Iterator<PeerEventListener> i$ = this.eventListeners.iterator();
        while (i$.hasNext()) {
            PeerEventListener listener;
            PeerEventListener peerEventListener = listener = i$.next();
            synchronized (peerEventListener) {
                List<Message> listenerItems = listener.getData(this, getdata);
                if (listenerItems == null) {
                    continue;
                }
                items.addAll(listenerItems);
            }
        }
        if (items.size() == 0) {
            return;
        }
        log.info("{}: Sending {} items gathered from listeners to peer", this.address, (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    private synchronized void processTransaction(Transaction tx) {
        log.debug("{}: Received broadcast tx {}", this.address, (Object)tx.getHashAsString());
        if (this.memoryPool != null) {
            tx = this.memoryPool.seen(tx, this.getAddress());
        }
        final Transaction ftx = tx;
        EventListenerInvoker.invoke(this.eventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onTransaction(Peer.this, ftx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBlock(Block m) throws IOException {
        log.debug("{}: Received broadcast block {}", this.address, (Object)m.getHashAsString());
        try {
            List<GetDataFuture<Block>> list = this.pendingGetBlockFutures;
            synchronized (list) {
                for (int i = 0; i < this.pendingGetBlockFutures.size(); ++i) {
                    GetDataFuture<Block> f = this.pendingGetBlockFutures.get(i);
                    if (!f.getItem().hash.equals(m.getHash())) continue;
                    f.setResult(m);
                    this.pendingGetBlockFutures.remove(i);
                    return;
                }
            }
            if (!this.downloadData) {
                log.warn("Received block we did not ask for: {}", (Object)m.getHashAsString());
                return;
            }
            this.pendingBlockDownloads.remove(m.getHash());
            if (this.blockChain.add(m)) {
                this.invokeOnBlocksDownloaded(m);
            } else {
                this.blockChainDownload(this.blockChain.getOrphanRoot(m.getHash()).getHash());
            }
        }
        catch (VerificationException e) {
            log.warn("Block verification failed", e);
        }
        catch (ScriptException e) {
            log.warn("Script exception", e);
        }
    }

    private synchronized void invokeOnBlocksDownloaded(final Block m) {
        final int blocksLeft = Math.max(0, this.getPeerBlockHeightDifference());
        EventListenerInvoker.invoke(this.eventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onBlocksDownloaded(Peer.this, m, blocksLeft);
            }
        });
    }

    private void processInv(InventoryMessage inv) throws IOException {
        List<InventoryItem> items = inv.getItems();
        LinkedList<InventoryItem> transactions = new LinkedList<InventoryItem>();
        LinkedList<InventoryItem> blocks = new LinkedList<InventoryItem>();
        block4: for (InventoryItem item : items) {
            switch (item.type) {
                case Transaction: {
                    transactions.add(item);
                    continue block4;
                }
                case Block: {
                    blocks.add(item);
                    continue block4;
                }
            }
            throw new IllegalStateException("Not implemented: " + (Object)((Object)item.type));
        }
        GetDataMessage getdata = new GetDataMessage(this.params);
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            InventoryItem item = (InventoryItem)it.next();
            if (this.memoryPool == null) {
                if (!this.downloadData) continue;
                getdata.addItem(item);
                continue;
            }
            if (this.memoryPool.maybeWasSeen(item.hash)) {
                it.remove();
            } else {
                log.debug("{}: getdata on tx {}", this.address, (Object)item.hash);
                getdata.addItem(item);
            }
            this.memoryPool.seen(item.hash, this.getAddress());
        }
        if (blocks.size() > 0 && this.downloadData) {
            for (InventoryItem item : blocks) {
                if (this.blockChain.isOrphan(item.hash)) {
                    this.blockChainDownload(this.blockChain.getOrphanRoot(item.hash).getHash());
                    continue;
                }
                if (this.pendingBlockDownloads.contains(item.hash)) continue;
                getdata.addItem(item);
                this.pendingBlockDownloads.add(item.hash);
            }
        }
        if (!getdata.getItems().isEmpty()) {
            this.sendMessage(getdata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Block> getBlock(Sha256Hash blockHash) throws IOException {
        log.info("Request to fetch block {}", blockHash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        InventoryItem inventoryItem = new InventoryItem(InventoryItem.Type.Block, blockHash);
        getdata.addItem(inventoryItem);
        GetDataFuture<Block> future = new GetDataFuture<Block>(inventoryItem);
        List<GetDataFuture<Block>> list = this.pendingGetBlockFutures;
        synchronized (list) {
            this.pendingGetBlockFutures.add(future);
        }
        this.sendMessage(getdata);
        return future;
    }

    public void setFastCatchupTime(long secondsSinceEpoch) {
        if (secondsSinceEpoch == 0L) {
            this.fastCatchupTimeSecs = this.params.genesisBlock.getTimeSeconds();
            this.downloadBlockBodies = true;
        } else {
            this.fastCatchupTimeSecs = secondsSinceEpoch;
            if (this.fastCatchupTimeSecs > this.blockChain.getChainHead().getHeader().getTimeSeconds()) {
                this.downloadBlockBodies = false;
            }
        }
    }

    public void addWallet(Wallet wallet) {
        this.addEventListener(wallet.getPeerEventListener());
    }

    public void removeWallet(Wallet wallet) {
        this.removeEventListener(wallet.getPeerEventListener());
    }

    public void sendMessage(Message m) throws IOException {
        Channels.write((Channel)this.channel, (Object)m);
    }

    private void blockChainDownload(Sha256Hash toHash) throws IOException {
        ArrayList<Sha256Hash> blockLocator = new ArrayList<Sha256Hash>(51);
        BlockStore store = this.blockChain.getBlockStore();
        StoredBlock chainHead = this.blockChain.getChainHead();
        Sha256Hash chainHeadHash = chainHead.getHeader().getHash();
        if (Objects.equal(this.lastGetBlocksBegin, chainHeadHash) && Objects.equal(this.lastGetBlocksEnd, toHash)) {
            log.info("blockChainDownload({}): ignoring duplicated request", (Object)toHash.toString());
            return;
        }
        log.info("{}: blockChainDownload({}) current head = {}", new Object[]{this.toString(), toHash.toString(), chainHead.getHeader().getHashAsString()});
        StoredBlock cursor = chainHead;
        for (int i = 100; cursor != null && i > 0; cursor = cursor.getPrev(store), --i) {
            blockLocator.add(cursor.getHeader().getHash());
            try {
                continue;
            }
            catch (BlockStoreException e) {
                log.error("Failed to walk the block chain whilst constructing a locator");
                throw new RuntimeException(e);
            }
        }
        if (cursor != null) {
            blockLocator.add(this.params.genesisBlock.getHash());
        }
        this.lastGetBlocksBegin = chainHeadHash;
        this.lastGetBlocksEnd = toHash;
        if (this.downloadBlockBodies) {
            GetBlocksMessage message = new GetBlocksMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        } else {
            GetHeadersMessage message = new GetHeadersMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        }
    }

    public synchronized void startBlockChainDownload() throws IOException {
        this.setDownloadData(true);
        if (this.getPeerBlockHeightDifference() >= 0) {
            EventListenerInvoker.invoke(this.eventListeners, new EventListenerInvoker<PeerEventListener>(){

                @Override
                public void invoke(PeerEventListener listener) {
                    listener.onChainDownloadStarted(Peer.this, Peer.this.getPeerBlockHeightDifference());
                }
            });
            this.blockChainDownload(Sha256Hash.ZERO_HASH);
        }
    }

    public int getPeerBlockHeightDifference() {
        int chainHeight = (int)this.peerVersionMessage.bestHeight;
        Preconditions.checkState(chainHeight > 0, "Connected to peer with zero/negative chain height", chainHeight);
        return chainHeight - this.blockChain.getChainHead().getHeight();
    }

    public boolean getDownloadData() {
        return this.downloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.downloadData = downloadData;
    }

    public PeerAddress getAddress() {
        return this.address;
    }

    public VersionMessage getPeerVersionMessage() {
        return this.peerVersionMessage;
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public long getBestHeight() {
        return this.peerVersionMessage.bestHeight;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetDataFuture<T extends Message>
    implements Future<T> {
        private boolean cancelled;
        private final InventoryItem item;
        private final CountDownLatch latch;
        private T result;

        GetDataFuture(InventoryItem item) {
            this.item = item;
            this.latch = new CountDownLatch(1);
        }

        @Override
        public boolean cancel(boolean b) {
            this.cancelled = true;
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.result != null || this.cancelled;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.latch.await();
            return (T)((Message)Preconditions.checkNotNull(this.result));
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.latch.await(l, timeUnit)) {
                throw new TimeoutException();
            }
            return (T)((Message)Preconditions.checkNotNull(this.result));
        }

        InventoryItem getItem() {
            return this.item;
        }

        void setResult(T result) {
            this.result = result;
            this.latch.countDown();
        }
    }

    class PeerHandler
    extends SimpleChannelHandler {
        PeerHandler() {
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelClosed(ctx, e);
            Peer.this.notifyDisconnect();
        }

        public void connectRequested(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.connectRequested(ctx, e);
            Peer.this.channel = e.getChannel();
            Peer.this.address = new PeerAddress((InetSocketAddress)e.getValue());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof IOException) {
                log.info(((Object)((Object)this)).toString() + " - " + e.getCause().getMessage());
            } else {
                log.warn(((Object)((Object)this)).toString() + " - ", e.getCause());
            }
            e.getChannel().close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Message m = (Message)e.getMessage();
            Peer peer = Peer.this;
            synchronized (peer) {
                Iterator i$ = Peer.this.eventListeners.iterator();
                while (i$.hasNext()) {
                    PeerEventListener listener;
                    PeerEventListener peerEventListener = listener = (PeerEventListener)i$.next();
                    synchronized (peerEventListener) {
                        m = listener.onPreMessageReceived(Peer.this, m);
                        if (m == null) {
                            break;
                        }
                    }
                }
            }
            if (m == null) {
                return;
            }
            if (m instanceof InventoryMessage) {
                Peer.this.processInv((InventoryMessage)m);
            } else if (m instanceof Block) {
                Peer.this.processBlock((Block)m);
            } else if (m instanceof Transaction) {
                Peer.this.processTransaction((Transaction)m);
            } else if (m instanceof GetDataMessage) {
                Peer.this.processGetData((GetDataMessage)m);
            } else if (!(m instanceof AddressMessage)) {
                if (m instanceof HeadersMessage) {
                    Peer.this.processHeaders((HeadersMessage)m);
                } else if (m instanceof AlertMessage) {
                    Peer.this.processAlert((AlertMessage)m);
                } else if (m instanceof VersionMessage) {
                    Peer.this.peerVersionMessage = (VersionMessage)m;
                    EventListenerInvoker.invoke(Peer.this.lifecycleListeners, new EventListenerInvoker<PeerLifecycleListener>(){

                        @Override
                        public void invoke(PeerLifecycleListener listener) {
                            listener.onPeerConnected(Peer.this);
                        }
                    });
                } else if (m instanceof VersionAck) {
                    if (Peer.this.peerVersionMessage == null) {
                        throw new ProtocolException("got a version ack before version");
                    }
                    if (Peer.this.isAcked) {
                        throw new ProtocolException("got more than one version ack");
                    }
                    Peer.this.isAcked = true;
                } else if (m instanceof Ping) {
                    if (((Ping)m).hasNonce()) {
                        Peer.this.sendMessage(new Pong(((Ping)m).getNonce()));
                    }
                } else if (!(m instanceof Pong)) {
                    log.warn("Received unhandled message: {}", m);
                }
            }
        }

        public Peer getPeer() {
            return Peer.this;
        }
    }

    static interface PeerLifecycleListener {
        public void onPeerConnected(Peer var1);

        public void onPeerDisconnected(Peer var1);
    }
}

