/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import java.io.Serializable;
import java.math.BigInteger;

public class StoredBlock
implements Serializable {
    private static final long serialVersionUID = -6097565241243701771L;
    private Block header;
    private BigInteger chainWork;
    private int height;

    public StoredBlock(Block header, BigInteger chainWork, int height) {
        this.header = header;
        this.chainWork = chainWork;
        this.height = height;
    }

    public Block getHeader() {
        return this.header;
    }

    public BigInteger getChainWork() {
        return this.chainWork;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean moreWorkThan(StoredBlock other) {
        return this.chainWork.compareTo(other.chainWork) > 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StoredBlock)) {
            return false;
        }
        StoredBlock o = (StoredBlock)other;
        return o.header.equals(this.header) && o.chainWork.equals(this.chainWork) && o.height == this.height;
    }

    public int hashCode() {
        return this.header.hashCode() ^ this.chainWork.hashCode() ^ this.height;
    }

    public StoredBlock build(Block block) throws VerificationException {
        BigInteger chainWork = this.chainWork.add(block.getWork());
        int height = this.height + 1;
        return new StoredBlock(block.cloneAsHeader(), chainWork, height);
    }

    public StoredBlock getPrev(BlockStore store) throws BlockStoreException {
        return store.get(this.getHeader().getPrevBlockHash());
    }

    public String toString() {
        return String.format("Block %s at height %d: %s", this.getHeader().getHashAsString(), this.getHeight(), this.getHeader().toString());
    }
}

