/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Script;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.Wallet;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class TransactionOutPoint
extends ChildMessage
implements Serializable {
    private static final long serialVersionUID = -6320880638344662579L;
    static final int MESSAGE_LENGTH = 36;
    private Sha256Hash hash;
    private long index;
    Transaction fromTx;

    public TransactionOutPoint(NetworkParameters params, long index, Transaction fromTx) {
        super(params);
        this.index = index;
        if (fromTx != null) {
            this.hash = fromTx.getHash();
            this.fromTx = fromTx;
        } else {
            this.hash = Sha256Hash.ZERO_HASH;
        }
        this.length = 36;
    }

    public TransactionOutPoint(NetworkParameters params, long index, Sha256Hash hash) {
        super(params);
        this.index = index;
        this.hash = hash;
        this.length = 36;
    }

    public TransactionOutPoint(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
    }

    public TransactionOutPoint(NetworkParameters params, byte[] payload, int offset, Message parent, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, payload, offset, parent, parseLazy, parseRetain, 36);
    }

    protected void parseLite() throws ProtocolException {
        this.length = 36;
    }

    void parse() throws ProtocolException {
        this.hash = this.readHash();
        this.index = this.readUint32();
    }

    int getMessageSize() {
        return 36;
    }

    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(Utils.reverseBytes(this.hash.getBytes()));
        Utils.uint32ToByteStreamLE(this.index, stream);
    }

    TransactionOutput getConnectedOutput() {
        if (this.fromTx == null) {
            return null;
        }
        return this.fromTx.getOutputs().get((int)this.index);
    }

    byte[] getConnectedPubKeyScript() {
        byte[] result = Preconditions.checkNotNull(this.getConnectedOutput().getScriptBytes());
        Preconditions.checkState(result.length > 0);
        return result;
    }

    byte[] getConnectedPubKeyHash() throws ScriptException {
        return this.getConnectedOutput().getScriptPubKey().getPubKeyHash();
    }

    public ECKey getConnectedKey(Wallet wallet) throws ScriptException {
        Script connectedScript = this.getConnectedOutput().getScriptPubKey();
        if (connectedScript.isSentToAddress()) {
            byte[] addressBytes = connectedScript.getPubKeyHash();
            return wallet.findKeyFromPubHash(addressBytes);
        }
        if (connectedScript.isSentToRawPubKey()) {
            byte[] pubkeyBytes = connectedScript.getPubKey();
            return wallet.findKeyFromPubKey(pubkeyBytes);
        }
        throw new ScriptException("Could not understand form of connected output script: " + connectedScript);
    }

    public String toString() {
        return "outpoint " + this.hash.toString() + ":" + this.index;
    }

    public Sha256Hash getHash() {
        this.maybeParse();
        return this.hash;
    }

    void setHash(Sha256Hash hash) {
        this.hash = hash;
    }

    public long getIndex() {
        this.maybeParse();
        return this.index;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TransactionOutPoint)) {
            return false;
        }
        TransactionOutPoint o = (TransactionOutPoint)other;
        return o.getIndex() == this.getIndex() && o.getHash().equals(this.getHash());
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }
}

