/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Transaction;
import com.google.common.base.Preconditions;

public class WalletTransaction {
    private Transaction transaction;
    private Pool pool;

    public WalletTransaction(Pool pool, Transaction transaction) {
        this.pool = Preconditions.checkNotNull(pool);
        this.transaction = transaction;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public Pool getPool() {
        return this.pool;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Pool {
        UNSPENT(4),
        SPENT(5),
        INACTIVE(2),
        DEAD(10),
        PENDING(16),
        PENDING_INACTIVE(18),
        ALL(-1);

        private int value;

        private Pool(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Pool valueOf(int value) {
            switch (value) {
                case 4: {
                    return UNSPENT;
                }
                case 5: {
                    return SPENT;
                }
                case 2: {
                    return INACTIVE;
                }
                case 10: {
                    return DEAD;
                }
                case 16: {
                    return PENDING;
                }
                case 18: {
                    return PENDING_INACTIVE;
                }
            }
            return null;
        }
    }
}

