/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import java.util.HashMap;
import java.util.Map;

public class MemoryBlockStore
implements BlockStore {
    private Map<Sha256Hash, StoredBlock> blockMap = new HashMap<Sha256Hash, StoredBlock>();
    private StoredBlock chainHead;

    public MemoryBlockStore(NetworkParameters params) {
        try {
            Block genesisHeader = params.genesisBlock.cloneAsHeader();
            StoredBlock storedGenesis = new StoredBlock(genesisHeader, genesisHeader.getWork(), 0);
            this.put(storedGenesis);
            this.setChainHead(storedGenesis);
        }
        catch (BlockStoreException e) {
            throw new RuntimeException(e);
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void put(StoredBlock block) throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        Sha256Hash hash = block.getHeader().getHash();
        this.blockMap.put(hash, block);
    }

    public synchronized StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        return this.blockMap.get(hash);
    }

    public StoredBlock getChainHead() throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        return this.chainHead;
    }

    public void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        if (this.blockMap == null) {
            throw new BlockStoreException("MemoryBlockStore is closed");
        }
        this.chainHead = chainHead;
    }

    public void close() {
        this.blockMap = null;
    }
}

