/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Coinbase;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import sockthing.DiffMath;
import sockthing.HexUtil;
import sockthing.PoolUser;
import sockthing.ShareSaveException;
import sockthing.StratumServer;
import sockthing.SubmitResult;

public class JobInfo {
    private NetworkParameters network_params;
    private StratumServer server;
    private String job_id;
    private JSONObject block_template;
    private byte[] extranonce1;
    private PoolUser pool_user;
    private HashSet<String> submits;
    private Sha256Hash share_target;
    private Coinbase coinbase;

    public JobInfo(StratumServer server, PoolUser pool_user, String job_id, JSONObject block_template, byte[] extranonce1) throws JSONException {
        this.pool_user = pool_user;
        this.server = server;
        this.network_params = this.network_params;
        this.job_id = job_id;
        this.block_template = block_template;
        this.extranonce1 = extranonce1;
        long value = block_template.getLong("coinbasevalue");
        int height = block_template.getInt("height");
        this.submits = new HashSet();
        this.coinbase = new Coinbase(server, pool_user, height, BigInteger.valueOf(value), this.getFeeTotal(), extranonce1);
        this.coinbase.genTx();
        this.share_target = DiffMath.getTargetForDifficulty(pool_user.getDifficulty());
    }

    public int getHeight() throws JSONException {
        return this.block_template.getInt("height");
    }

    private BigInteger getFeeTotal() throws JSONException {
        long fee_total = 0L;
        JSONArray transactions = this.block_template.getJSONArray("transactions");
        for (int i = 0; i < transactions.length(); ++i) {
            JSONObject tx = transactions.getJSONObject(i);
            long fee = tx.getLong("fee");
            fee_total += fee;
        }
        return BigInteger.valueOf(fee_total);
    }

    public JSONObject getMiningNotifyMessage(boolean clean) throws JSONException {
        JSONObject msg = new JSONObject();
        msg.put("id", JSONObject.NULL);
        msg.put("method", "mining.notify");
        JSONArray roots = new JSONArray();
        String protocol = "00000002";
        String diffbits = this.block_template.getString("bits");
        int ntime = (int)System.currentTimeMillis() / 1000;
        String ntime_str = HexUtil.getIntAsHex(ntime);
        JSONArray params = new JSONArray();
        params.put(this.job_id);
        params.put(HexUtil.swapBytesInsideWord(HexUtil.swapEndianHexString(this.block_template.getString("previousblockhash"))));
        params.put(Hex.encodeHexString(this.coinbase.getCoinbase1()));
        params.put(Hex.encodeHexString(this.coinbase.getCoinbase2()));
        params.put(this.getMerkleRoots());
        params.put(protocol);
        params.put(this.block_template.getString("bits"));
        params.put(HexUtil.getIntAsHex(this.block_template.getInt("curtime")));
        params.put(clean);
        msg.put("params", params);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSubmit(JSONArray params, SubmitResult submit_result) {
        String unique_id = HexUtil.sha256(params.toString());
        try {
            this.validateSubmitInternal(params, submit_result);
        }
        catch (Throwable t) {
            submit_result.our_result = "N";
            submit_result.reason = "Exception: " + t;
        }
        finally {
            try {
                this.server.getShareSaver().saveShare(this.pool_user, submit_result, "sockthing/" + this.server.getInstanceId(), unique_id);
            }
            catch (ShareSaveException e) {
                submit_result.our_result = "N";
                submit_result.reason = "Exception: " + e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSubmitInternal(JSONArray params, SubmitResult submit_result) throws JSONException, DecoderException, ShareSaveException {
        String user = params.getString(0);
        String job_id = params.getString(1);
        byte[] extranonce2 = Hex.decodeHex(params.getString(2).toCharArray());
        String ntime = params.getString(3);
        String nonce = params.getString(4);
        String submit_cannonical_string = params.getString(2) + params.getString(3) + params.getString(4);
        HashSet<String> hashSet = this.submits;
        synchronized (hashSet) {
            if (this.submits.contains(submit_cannonical_string)) {
                submit_result.our_result = "N";
                submit_result.reason = "duplicate";
                return;
            }
            this.submits.add(submit_cannonical_string);
        }
        int stale = this.server.checkStale(this.getHeight());
        if (stale >= 2) {
            submit_result.our_result = "N";
            submit_result.reason = "quite stale";
            return;
        }
        if (stale == 1) {
            submit_result.reason = "slightly stale";
        }
        Coinbase coinbase = this.coinbase;
        synchronized (coinbase) {
            this.coinbase.setExtranonce2(extranonce2);
            Sha256Hash coinbase_hash = this.coinbase.genTx().getHash();
            Sha256Hash merkle_root = new Sha256Hash(HexUtil.swapEndianHexString(coinbase_hash.toString()));
            JSONArray branches = this.getMerkleRoots();
            for (int i = 0; i < branches.length(); ++i) {
                Sha256Hash br = new Sha256Hash(branches.getString(i));
                merkle_root = HexUtil.treeHash(merkle_root, br);
            }
            try {
                StringBuilder header = new StringBuilder();
                header.append("00000002");
                header.append(HexUtil.swapBytesInsideWord(HexUtil.swapEndianHexString(this.block_template.getString("previousblockhash"))));
                header.append(HexUtil.swapBytesInsideWord(merkle_root.toString()));
                header.append(ntime);
                header.append(this.block_template.getString("bits"));
                header.append(nonce);
                String header_str = header.toString();
                header_str = HexUtil.swapBytesInsideWord(header_str);
                System.out.println("Header: " + header_str);
                System.out.println("Header bytes: " + header_str.length());
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(Hex.decodeHex(header_str.toCharArray()));
                byte[] pass = md.digest();
                md.reset();
                md.update(pass);
                Sha256Hash blockhash = new Sha256Hash(HexUtil.swapEndianHexString(new Sha256Hash(md.digest()).toString()));
                System.out.println("Found block hash: " + blockhash);
                submit_result.hash = blockhash;
                if (blockhash.toString().compareTo(this.share_target.toString()) >= 0) {
                    submit_result.our_result = "N";
                    submit_result.reason = "H-not-zero";
                    return;
                }
                submit_result.our_result = "Y";
                Object upstream_result = null;
                if (blockhash.toString().compareTo(this.block_template.getString("target")) < 0) {
                    submit_result.upstream_result = this.buildAndSubmitBlock(params, merkle_root);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String buildAndSubmitBlock(JSONArray params, Sha256Hash merkleRoot) throws JSONException, DecoderException {
        System.out.println("WE CAN BUILD A BLOCK.  WE HAVE THE TECHNOLOGY.");
        String user = params.getString(0);
        String job_id = params.getString(1);
        byte[] extranonce2 = Hex.decodeHex(params.getString(2).toCharArray());
        String ntime = params.getString(3);
        String nonce = params.getString(4);
        long time = Long.parseLong(ntime, 16);
        long target = Long.parseLong(this.block_template.getString("bits"), 16);
        long nonce_l = Long.parseLong(nonce, 16);
        LinkedList<Transaction> lst = new LinkedList<Transaction>();
        lst.add(this.coinbase.genTx());
        JSONArray transactions = this.block_template.getJSONArray("transactions");
        for (int i = 0; i < transactions.length(); ++i) {
            JSONObject tx = transactions.getJSONObject(i);
            try {
                Transaction tx_obj = new Transaction(this.network_params, Hex.decodeHex(tx.getString("data").toCharArray()));
                lst.add(tx_obj);
                continue;
            }
            catch (ProtocolException e) {
                throw new RuntimeException(e);
            }
        }
        Block block = new Block(this.network_params, 2L, new Sha256Hash(this.block_template.getString("previousblockhash")), new Sha256Hash(HexUtil.swapEndianHexString(merkleRoot.toString())), time, target, nonce_l, lst);
        System.out.println("Constructed block hash: " + block.getHash());
        try {
            block.verifyTransactions();
            System.out.println("Block VERIFIED");
            byte[] blockbytes = block.bitcoinSerialize();
            System.out.println("Bytes: " + blockbytes.length);
            return this.server.submitBlock(block);
        }
        catch (VerificationException e) {
            e.printStackTrace();
            return "N";
        }
    }

    public JSONArray getMerkleRoots() throws JSONException {
        ArrayList<Sha256Hash> hashes = new ArrayList<Sha256Hash>();
        JSONArray transactions = this.block_template.getJSONArray("transactions");
        for (int i = 0; i < transactions.length(); ++i) {
            JSONObject tx = transactions.getJSONObject(i);
            Sha256Hash hash = new Sha256Hash(HexUtil.swapEndianHexString(tx.getString("hash")));
            hashes.add(hash);
        }
        JSONArray roots = new JSONArray();
        while (hashes.size() > 0) {
            ArrayList<Sha256Hash> next_lst = new ArrayList<Sha256Hash>();
            roots.put(((Sha256Hash)hashes.get(0)).toString());
            for (int i = 1; i < hashes.size(); i += 2) {
                if (i + 1 == hashes.size()) {
                    next_lst.add(HexUtil.treeHash((Sha256Hash)hashes.get(i), (Sha256Hash)hashes.get(i)));
                    continue;
                }
                next_lst.add(HexUtil.treeHash((Sha256Hash)hashes.get(i), (Sha256Hash)hashes.get(i + 1)));
            }
            hashes = next_lst;
        }
        return roots;
    }
}

