/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import sockthing.Config;
import sockthing.StratumServer;

public class MetricsReporter
extends Thread {
    StratumServer server;
    AmazonCloudWatchClient cw;
    LinkedBlockingQueue<PutMetricDataRequest> put_queue;

    public MetricsReporter(StratumServer server) {
        this.server = server;
        Config conf = server.getConfig();
        this.put_queue = new LinkedBlockingQueue();
        conf.require("metrics_aws_region");
        conf.require("metrics_aws_key");
        conf.require("metrics_aws_secret");
        this.cw = new AmazonCloudWatchClient(new BasicAWSCredentials(conf.get("metrics_aws_key"), conf.get("metrics_aws_secret")));
        this.cw.setEndpoint("monitoring." + conf.get("metrics_aws_region") + ".amazonaws.com");
        this.setDaemon(true);
        this.start();
    }

    public String getNamespace() {
        return "sockthing/" + this.server.getInstanceId();
    }

    public String getGlobalNamespace() {
        return "sockthing";
    }

    public void metricCount(String name, double count) {
        PutMetricDataRequest req = new PutMetricDataRequest();
        LinkedList<MetricDatum> lst = new LinkedList<MetricDatum>();
        MetricDatum md = new MetricDatum();
        md.setMetricName(name);
        md.setValue(count);
        lst.add(md);
        req.setMetricData(lst);
        req.setNamespace(this.getNamespace());
        try {
            this.put_queue.put(req);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void metricTime(String name, double milliseconds) {
        PutMetricDataRequest req = new PutMetricDataRequest();
        LinkedList<MetricDatum> lst = new LinkedList<MetricDatum>();
        MetricDatum md = new MetricDatum();
        md.setMetricName(name);
        md.setValue(milliseconds);
        md.setUnit("Milliseconds");
        lst.add(md);
        req.setMetricData(lst);
        req.setNamespace(this.getGlobalNamespace());
        try {
            this.put_queue.put(req);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.doRun();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void doRun() throws Exception {
        PutMetricDataRequest put = this.put_queue.take();
        if (put != null) {
            this.cw.putMetricData(put);
        }
    }
}

