/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.google.bitcoin.core.Sha256Hash;
import org.json.JSONException;
import org.json.JSONObject;
import sockthing.Config;
import sockthing.PoolUser;
import sockthing.ShareSaveException;
import sockthing.ShareSaver;
import sockthing.StratumServer;
import sockthing.SubmitResult;

public class ShareSaverMessaging
implements ShareSaver {
    protected StratumServer server;
    protected AmazonSNSClient sns;
    protected String topic_arn;
    protected AmazonSQSClient sqs;
    protected String queue_url;
    protected ShareSaver inner_saver;

    public ShareSaverMessaging(StratumServer server, ShareSaver inner_saver) {
        this.server = server;
        this.inner_saver = inner_saver;
        Config config = server.getConfig();
        config.require("saver_messaging_topic_arn");
        config.require("saver_messaging_aws_key");
        config.require("saver_messaging_aws_secret");
        config.require("saver_messaging_sqs_queue_url");
        config.require("saver_messaging_sqs_region");
        config.require("saver_messaging_read_threads");
        BasicAWSCredentials creds = new BasicAWSCredentials(config.get("saver_messaging_aws_key"), config.get("saver_messaging_aws_secret"));
        this.sns = new AmazonSNSClient(creds);
        this.topic_arn = config.get("saver_messaging_topic_arn");
        String region = this.topic_arn.split(":")[3];
        this.sns.setEndpoint("sns." + region + ".amazonaws.com");
        this.sqs = new AmazonSQSClient(creds);
        this.sqs.setEndpoint("sqs." + config.get("saver_messaging_sqs_region") + ".amazonaws.com");
        this.queue_url = config.get("saver_messaging_sqs_queue_url");
        int read_threads = Integer.parseInt(config.get("saver_messaging_read_threads"));
        for (int i = 0; i < read_threads; ++i) {
            new MessageReadThread().start();
        }
    }

    @Override
    public void saveShare(PoolUser pu, SubmitResult submit_result, String source, String unique_id) throws ShareSaveException {
        try {
            JSONObject msg = new JSONObject();
            msg.put("user", pu.getName());
            msg.put("worker", pu.getWorkerName());
            msg.put("difficulty", pu.getDifficulty());
            msg.put("source", source);
            msg.put("our_result", submit_result.our_result);
            msg.put("upstream_result", submit_result.upstream_result);
            msg.put("reason", submit_result.reason);
            msg.put("unique_id", unique_id);
            String hash_str = null;
            if (submit_result.hash != null) {
                hash_str = submit_result.hash.toString();
            }
            msg.put("hash", hash_str);
            msg.put("client", submit_result.client_version);
            this.sns.publish(new PublishRequest(this.topic_arn, msg.toString(2), "share - " + pu.getName()));
        }
        catch (AmazonClientException e) {
            throw new ShareSaveException(e);
        }
        catch (JSONException e) {
            throw new ShareSaveException(e);
        }
    }

    public class MessageReadThread
    extends Thread {
        public MessageReadThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.doRun();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public void doRun() throws ShareSaveException, JSONException {
            ReceiveMessageRequest recv_req = new ReceiveMessageRequest(ShareSaverMessaging.this.queue_url);
            recv_req.setWaitTimeSeconds(20);
            recv_req = recv_req.withAttributeNames("All");
            recv_req.setMaxNumberOfMessages(10);
            for (Message msg : ShareSaverMessaging.this.sqs.receiveMessage(recv_req).getMessages()) {
                int recv_count = Integer.parseInt(msg.getAttributes().get("ApproximateReceiveCount"));
                JSONObject sns_msg = new JSONObject(msg.getBody());
                JSONObject save_msg = new JSONObject(sns_msg.getString("Message"));
                String worker = save_msg.getString("worker");
                String user = save_msg.getString("user");
                int difficulty = save_msg.getInt("difficulty");
                String source = save_msg.getString("source");
                String unique_id = save_msg.getString("unique_id");
                PoolUser pu = new PoolUser(worker);
                pu.setName(user);
                pu.setDifficulty(difficulty);
                SubmitResult res = new SubmitResult();
                if (save_msg.has("hash")) {
                    String hash_str = save_msg.getString("hash");
                    res.hash = new Sha256Hash(hash_str);
                }
                if (save_msg.has("our_result")) {
                    res.our_result = save_msg.getString("our_result");
                }
                if (save_msg.has("upstream_result")) {
                    res.upstream_result = save_msg.getString("upstream_result");
                }
                if (save_msg.has("reason")) {
                    res.reason = save_msg.getString("reason");
                }
                if (save_msg.has("client")) {
                    res.client_version = save_msg.getString("client");
                }
                ShareSaverMessaging.this.inner_saver.saveShare(pu, res, source, unique_id);
                ShareSaverMessaging.this.sqs.deleteMessage(new DeleteMessageRequest(ShareSaverMessaging.this.queue_url, msg.getReceiptHandle()));
            }
        }
    }
}

