/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import java.io.PrintStream;
import java.net.Socket;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONArray;
import org.json.JSONObject;
import sockthing.Config;
import sockthing.HexUtil;
import sockthing.JobInfo;
import sockthing.PoolUser;
import sockthing.StratumServer;
import sockthing.SubmitResult;
import sockthing.UserSessionData;

public class StratumConnection {
    public static final String RUNTIME_SESSION = HexUtil.sha256("" + new Random().nextLong());
    private StratumServer server;
    private Socket sock;
    private String connection_id;
    private AtomicLong last_network_action;
    private volatile boolean open;
    private volatile boolean mining_subscribe = false;
    private PoolUser user;
    private Config config;
    private byte[] extranonce1;
    private UserSessionData user_session_data;
    private AtomicLong next_request_id = new AtomicLong(10000L);
    private LinkedBlockingQueue<JSONObject> out_queue = new LinkedBlockingQueue();
    private Random rnd;
    private long get_client_id = -1L;
    private String client_version;

    public StratumConnection(StratumServer server, Socket sock, String connection_id) {
        this.server = server;
        this.config = server.getConfig();
        this.sock = sock;
        this.connection_id = connection_id;
        this.open = true;
        this.last_network_action = new AtomicLong(System.nanoTime());
        this.extranonce1 = UserSessionData.getExtranonce1();
        new OutThread().start();
        new InThread().start();
    }

    public void close() {
        this.open = false;
        try {
            this.sock.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getLastNetworkAction() {
        return this.last_network_action.get();
    }

    public long getNextRequestId() {
        return this.next_request_id.getAndIncrement();
    }

    protected void updateLastNetworkAction() {
        this.last_network_action.set(System.nanoTime());
    }

    public void sendMessage(JSONObject msg) {
        try {
            this.out_queue.put(msg);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendRealJob(JSONObject block_template, boolean clean) throws Exception {
        if (this.user_session_data == null) {
            return;
        }
        if (!this.mining_subscribe) {
            return;
        }
        String job_id = this.user_session_data.getNextJobId();
        JobInfo ji = new JobInfo(this.server, this.user, job_id, block_template, this.extranonce1);
        this.user_session_data.saveJobInfo(job_id, ji);
        JSONObject msg = ji.getMiningNotifyMessage(clean);
        this.sendMessage(msg);
    }

    private void processInMessage(JSONObject msg) throws Exception {
        long id = msg.getLong("id");
        if (id == this.get_client_id) {
            this.client_version = msg.getString("result");
            return;
        }
        if (!msg.has("method")) {
            System.out.println("Unknown message: " + msg.toString());
            return;
        }
        String method = msg.getString("method");
        if (method.equals("mining.subscribe")) {
            JSONObject reply = new JSONObject();
            reply.put("id", id);
            reply.put("error", JSONObject.NULL);
            JSONArray lst2 = new JSONArray();
            lst2.put("mining.notify");
            lst2.put("hhtt");
            JSONArray lst = new JSONArray();
            lst.put(lst2);
            lst.put(Hex.encodeHexString(this.extranonce1));
            lst.put(4);
            lst.put(RUNTIME_SESSION);
            reply.put("result", lst);
            this.sendMessage(reply);
            this.mining_subscribe = true;
        } else if (method.equals("mining.authorize")) {
            JSONArray params = msg.getJSONArray("params");
            String username = (String)params.get(0);
            String password = (String)params.get(1);
            PoolUser pu = this.server.getAuthHandler().authenticate(username, password);
            JSONObject reply = new JSONObject();
            reply.put("id", id);
            if (pu == null) {
                reply.put("error", "unknown user");
                reply.put("result", false);
                this.sendMessage(reply);
            } else {
                reply.put("result", true);
                reply.put("error", JSONObject.NULL);
                this.user = pu;
                this.sendMessage(reply);
                this.sendDifficulty();
                this.sendGetClient();
                this.user_session_data = this.server.getUserSessionData(pu);
                this.sendRealJob(this.server.getCurrentBlockTemplate(), false);
            }
        } else if (method.equals("mining.resume")) {
            JSONArray params = msg.getJSONArray("params");
            String session_id = params.getString(0);
            JSONObject reply = new JSONObject();
            reply.put("id", id);
            if (!session_id.equals(RUNTIME_SESSION)) {
                reply.put("error", "bad session id");
                reply.put("result", false);
                this.sendMessage(reply);
            } else {
                reply.put("result", true);
                reply.put("error", JSONObject.NULL);
                this.sendMessage(reply);
                this.mining_subscribe = true;
            }
        } else if (method.equals("mining.submit")) {
            JSONArray params = msg.getJSONArray("params");
            String job_id = params.getString(1);
            JobInfo ji = this.user_session_data.getJobInfo(job_id);
            if (ji == null) {
                JSONObject reply = new JSONObject();
                reply.put("id", id);
                reply.put("result", false);
                reply.put("error", "unknown-work");
                this.sendMessage(reply);
            } else {
                SubmitResult res = new SubmitResult();
                res.client_version = this.client_version;
                ji.validateSubmit(params, res);
                JSONObject reply = new JSONObject();
                reply.put("id", id);
                if (res.our_result.equals("Y")) {
                    reply.put("result", true);
                } else {
                    reply.put("result", false);
                }
                if (res.reason == null) {
                    reply.put("error", JSONObject.NULL);
                } else {
                    reply.put("error", res.reason);
                }
                this.sendMessage(reply);
            }
        }
    }

    private void sendDifficulty() throws Exception {
        JSONObject msg = new JSONObject();
        msg.put("id", JSONObject.NULL);
        msg.put("method", "mining.set_difficulty");
        JSONArray lst = new JSONArray();
        lst.put(this.user.getDifficulty());
        msg.put("params", lst);
        this.sendMessage(msg);
    }

    private void sendGetClient() throws Exception {
        long id;
        this.get_client_id = id = this.getNextRequestId();
        JSONObject msg = new JSONObject();
        msg.put("id", id);
        msg.put("method", "client.get_version");
        this.sendMessage(msg);
    }

    public class InThread
    extends Thread {
        public InThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Scanner scan = new Scanner(StratumConnection.this.sock.getInputStream());
                while (StratumConnection.this.open) {
                    String line = scan.nextLine();
                    StratumConnection.this.updateLastNetworkAction();
                    if ((line = line.trim()).length() <= 0) continue;
                    JSONObject msg = new JSONObject(line);
                    System.out.println("In: " + msg.toString());
                    StratumConnection.this.processInMessage(msg);
                }
            }
            catch (Exception e) {
                System.out.println("" + StratumConnection.this.connection_id + ": " + e);
                e.printStackTrace();
            }
            finally {
                StratumConnection.this.close();
            }
        }
    }

    public class OutThread
    extends Thread {
        public OutThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PrintStream out = new PrintStream(StratumConnection.this.sock.getOutputStream());
                while (StratumConnection.this.open) {
                    JSONObject msg = (JSONObject)StratumConnection.this.out_queue.poll(30L, TimeUnit.SECONDS);
                    if (msg == null) continue;
                    String msg_str = msg.toString();
                    out.println(msg_str);
                    System.out.println("Out: " + msg.toString());
                    StratumConnection.this.updateLastNetworkAction();
                }
            }
            catch (Exception e) {
                System.out.println(StratumConnection.this.connection_id + ": " + e);
                e.printStackTrace();
            }
            finally {
                StratumConnection.this.close();
            }
        }
    }
}

