/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.NetworkParameters;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import sockthing.AddressDifficultyAuthHandler;
import sockthing.AuthHandler;
import sockthing.BitcoinRPC;
import sockthing.Config;
import sockthing.DBShareSaver;
import sockthing.MetricsReporter;
import sockthing.OutputMonster;
import sockthing.OutputMonsterShareFees;
import sockthing.PoolUser;
import sockthing.ShareSaver;
import sockthing.ShareSaverMessaging;
import sockthing.StratumConnection;
import sockthing.UserSessionData;

public class StratumServer
extends Thread {
    private int port = 3333;
    private BitcoinRPC bitcoin_rpc;
    private long max_idle_time = 300000000000L;
    private Map<String, StratumConnection> conn_map = new HashMap<String, StratumConnection>(1024, 0.5f);
    private Config config;
    private AuthHandler auth_handler;
    private NetworkParameters network_params;
    private ShareSaver share_saver;
    private OutputMonster output_monster;
    private MetricsReporter metrics_reporter;
    private String instance_id;
    private JSONObject cached_block_template;
    private Map<String, UserSessionData> user_session_data_map = new HashMap<String, UserSessionData>(1024, 0.5f);
    private volatile int current_block;
    private volatile long current_block_update_time;

    public StratumServer(Config config) {
        this.config = config;
        config.require("port");
        this.port = config.getInt("port");
        this.bitcoin_rpc = new BitcoinRPC(config);
    }

    public void setAuthHandler(AuthHandler auth_handler) {
        this.auth_handler = auth_handler;
    }

    public AuthHandler getAuthHandler() {
        return this.auth_handler;
    }

    public void setMetricsReporter(MetricsReporter mr) {
        this.metrics_reporter = mr;
    }

    public MetricsReporter getMetricsReporter() {
        return this.metrics_reporter;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getInstanceId() {
        return this.instance_id;
    }

    public void setInstanceId(String instance_id) {
        this.instance_id = instance_id;
    }

    public void setShareSaver(ShareSaver share_saver) {
        this.share_saver = share_saver;
    }

    public ShareSaver getShareSaver() {
        return this.share_saver;
    }

    public void setOutputMonster(OutputMonster output_monster) {
        this.output_monster = output_monster;
    }

    public OutputMonster getOutputMonster() {
        return this.output_monster;
    }

    public NetworkParameters getNetworkParameters() {
        return this.network_params;
    }

    public void setNetworkParameters(NetworkParameters network_params) {
        this.network_params = network_params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ServerSocket ss = new ServerSocket(this.port, 256);
            ss.setReuseAddress(true);
            new TimeoutThread().start();
            new NewBlockThread().start();
            new PruneThread().start();
            while (ss.isBound()) {
                try {
                    Socket sock = ss.accept();
                    String id = UUID.randomUUID().toString();
                    StratumConnection conn = new StratumConnection(this, sock, id);
                    Map<String, StratumConnection> map = this.conn_map;
                    synchronized (map) {
                        this.conn_map.put(id, conn);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int checkStale(int next_block) {
        if (next_block == this.current_block + 1) {
            return 0;
        }
        if (next_block == this.current_block && this.current_block_update_time + 10000L > System.currentTimeMillis()) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerUpdate(boolean clean) throws Exception {
        System.out.println("Update triggered. Clean: " + clean);
        this.cached_block_template = null;
        long t1_get_block = System.currentTimeMillis();
        JSONObject block_template = this.getCurrentBlockTemplate();
        long t2_get_block = System.currentTimeMillis();
        this.getMetricsReporter().metricTime("GetBlockTemplateTime", t2_get_block - t1_get_block);
        long t1_update_connection = System.currentTimeMillis();
        LinkedList<Map.Entry<String, StratumConnection>> lst = new LinkedList<Map.Entry<String, StratumConnection>>();
        Map<String, StratumConnection> map = this.conn_map;
        synchronized (map) {
            lst.addAll(this.conn_map.entrySet());
        }
        for (Map.Entry entry : lst) {
            ((StratumConnection)entry.getValue()).sendRealJob(block_template, clean);
        }
        long t2_update_connection = System.currentTimeMillis();
        this.getMetricsReporter().metricTime("UpdateConnectionsTime", t2_update_connection - t1_update_connection);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Expected exactly one argument, a config file");
            System.out.println("java -jar SockThing.jar pool.cfg");
            return;
        }
        Config conf = new Config(args[0]);
        conf.require("pay_to_address");
        conf.require("network");
        conf.require("instance_id");
        conf.require("coinbase_text");
        conf.require("saver_messaging_enabled");
        StratumServer server = new StratumServer(conf);
        server.setInstanceId(conf.get("instance_id"));
        server.setMetricsReporter(new MetricsReporter(server));
        server.setAuthHandler(new AddressDifficultyAuthHandler(server));
        if (conf.getBoolean("saver_messaging_enabled")) {
            server.setShareSaver(new ShareSaverMessaging(server, new DBShareSaver(conf)));
        } else {
            server.setShareSaver(new DBShareSaver(conf));
        }
        String network = conf.get("network");
        if (network.equals("prodnet")) {
            server.setNetworkParameters(NetworkParameters.prodNet());
        } else if (network.equals("testnet")) {
            server.setNetworkParameters(NetworkParameters.testNet3());
        }
        server.setOutputMonster(new OutputMonsterShareFees(conf, server.getNetworkParameters()));
        server.start();
    }

    public JSONObject getCurrentBlockTemplate() throws IOException, JSONException {
        JSONObject c = this.cached_block_template;
        if (c != null) {
            return c;
        }
        JSONObject post = new JSONObject(BitcoinRPC.getSimplePostRequest("getblocktemplate"));
        this.cached_block_template = c = this.bitcoin_rpc.sendPost(post).getJSONObject("result");
        this.getMetricsReporter().metricCount("getblocktemplate", 1.0);
        return c;
    }

    public String submitBlock(Block blk) {
        try {
            JSONObject result = this.bitcoin_rpc.submitBlock(blk);
            System.out.println(result.toString(2));
            return "Y";
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "N";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSessionData getUserSessionData(PoolUser pu) {
        Map<String, UserSessionData> map = this.user_session_data_map;
        synchronized (map) {
            UserSessionData ud = this.user_session_data_map.get(pu.getWorkerName());
            if (ud == null) {
                ud = new UserSessionData(this);
            }
            this.user_session_data_map.put(pu.getWorkerName(), ud);
            return ud;
        }
    }

    public class NewBlockThread
    extends Thread {
        int last_block;
        long last_update_time;

        public NewBlockThread() {
            this.setDaemon(true);
            this.last_update_time = System.currentTimeMillis();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                        this.doRun();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void doRun() throws Exception {
            JSONObject reply = StratumServer.this.bitcoin_rpc.doSimplePostRequest("getblockcount");
            int block_height = reply.getInt("result");
            if (block_height != this.last_block) {
                System.out.println(reply);
                StratumServer.this.triggerUpdate(true);
                this.last_block = block_height;
                this.last_update_time = System.currentTimeMillis();
                StratumServer.this.current_block_update_time = System.currentTimeMillis();
                StratumServer.this.current_block = block_height;
            }
            if (this.last_update_time + 30000L < System.currentTimeMillis()) {
                StratumServer.this.triggerUpdate(false);
                this.last_update_time = System.currentTimeMillis();
            }
        }
    }

    public class PruneThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(43000L);
                        this.doRun();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun() throws Exception {
            TreeSet to_delete = new TreeSet();
            int user_sessions = 0;
            int user_jobs = 0;
            Map map = StratumServer.this.user_session_data_map;
            synchronized (map) {
                user_sessions = StratumServer.this.user_session_data_map.size();
                for (Map.Entry me : StratumServer.this.user_session_data_map.entrySet()) {
                    user_jobs += ((UserSessionData)me.getValue()).getJobCount();
                    if (!((UserSessionData)me.getValue()).prune()) continue;
                    to_delete.add(me.getKey());
                }
                for (String id : to_delete) {
                    StratumServer.this.user_session_data_map.remove(id);
                }
            }
            StratumServer.this.metrics_reporter.metricCount("usersessions", user_sessions);
            StratumServer.this.metrics_reporter.metricCount("userjobs", user_jobs);
        }
    }

    public class TimeoutThread
    extends Thread {
        public TimeoutThread() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                LinkedList lst = new LinkedList();
                Map map = StratumServer.this.conn_map;
                synchronized (map) {
                    lst.addAll(StratumServer.this.conn_map.entrySet());
                }
                StratumServer.this.getMetricsReporter().metricCount("connections", lst.size());
                for (Map.Entry entry : lst) {
                    if (((StratumConnection)entry.getValue()).getLastNetworkAction() + StratumServer.this.max_idle_time >= System.nanoTime()) continue;
                    System.out.println("Closing connection due to inactivity: " + (String)entry.getKey());
                    ((StratumConnection)entry.getValue()).close();
                    Map map2 = StratumServer.this.conn_map;
                    synchronized (map2) {
                        StratumServer.this.conn_map.remove(entry.getKey());
                    }
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

