/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;

public abstract class ChildMessage
extends Message {
    private static final long serialVersionUID = -7657113383624517931L;
    private Message parent;

    protected ChildMessage() {
    }

    public ChildMessage(NetworkParameters params) {
        super(params);
    }

    public ChildMessage(NetworkParameters params, byte[] msg, int offset, int protocolVersion) throws ProtocolException {
        super(params, msg, offset, protocolVersion);
    }

    public ChildMessage(NetworkParameters params, byte[] msg, int offset, int protocolVersion, Message parent, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, msg, offset, protocolVersion, parseLazy, parseRetain, length);
        this.parent = parent;
    }

    public ChildMessage(NetworkParameters params, byte[] msg, int offset) throws ProtocolException {
        super(params, msg, offset);
    }

    public ChildMessage(NetworkParameters params, byte[] msg, int offset, Message parent, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, msg, offset, parseLazy, parseRetain, length);
        this.parent = parent;
    }

    public void setParent(Message parent) {
        if (this.parent != null && this.parent != parent && parent != null) {
            this.parent.unCache();
        }
        this.parent = parent;
    }

    protected void unCache() {
        super.unCache();
        if (this.parent != null) {
            this.parent.unCache();
        }
    }

    protected void adjustLength(int adjustment) {
        this.adjustLength(0, adjustment);
    }

    protected void adjustLength(int newArraySize, int adjustment) {
        super.adjustLength(newArraySize, adjustment);
        if (this.parent != null) {
            this.parent.adjustLength(newArraySize, adjustment);
        }
    }
}

