/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.VersionedChecksummedBytes;
import java.math.BigInteger;

public class DumpedPrivateKey
extends VersionedChecksummedBytes {
    DumpedPrivateKey(NetworkParameters params, byte[] keyBytes) {
        super(params.dumpedPrivateKeyHeader, keyBytes);
        if (keyBytes.length != 32) {
            throw new RuntimeException("Keys are 256 bits, so you must provide 32 bytes, got " + keyBytes.length + " bytes");
        }
    }

    public DumpedPrivateKey(NetworkParameters params, String encoded) throws AddressFormatException {
        super(encoded);
        if (params != null && this.version != params.dumpedPrivateKeyHeader) {
            throw new AddressFormatException("Mismatched version number, trying to cross networks? " + this.version + " vs " + params.dumpedPrivateKeyHeader);
        }
    }

    public ECKey getKey() {
        return new ECKey(new BigInteger(1, this.bytes));
    }
}

