/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListMessage
extends Message {
    private static final long serialVersionUID = -4275896329391143643L;
    private long arrayLen;
    private List<InventoryItem> items;
    private static final long MAX_INVENTORY_ITEMS = 50000L;

    public ListMessage(NetworkParameters params, byte[] bytes) throws ProtocolException {
        super(params, bytes, 0);
    }

    public ListMessage(NetworkParameters params, byte[] msg, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, msg, 0, parseLazy, parseRetain, length);
    }

    public ListMessage(NetworkParameters params) {
        super(params);
        this.items = new ArrayList<InventoryItem>();
        this.length = 1;
    }

    public List<InventoryItem> getItems() {
        this.maybeParse();
        return Collections.unmodifiableList(this.items);
    }

    public void addItem(InventoryItem item) {
        this.unCache();
        this.length -= VarInt.sizeOf(this.items.size());
        this.items.add(item);
        this.length += VarInt.sizeOf(this.items.size()) + 36;
    }

    public void removeItem(int index) {
        this.unCache();
        this.length -= VarInt.sizeOf(this.items.size());
        this.items.remove(index);
        this.length += VarInt.sizeOf(this.items.size()) - 36;
    }

    @Override
    protected void parseLite() throws ProtocolException {
        this.arrayLen = this.readVarInt();
        if (this.arrayLen > 50000L) {
            throw new ProtocolException("Too many items in INV message: " + this.arrayLen);
        }
        this.length = (int)((long)(this.cursor - this.offset) + this.arrayLen * 36L);
    }

    @Override
    public void parse() throws ProtocolException {
        this.items = new ArrayList<InventoryItem>((int)this.arrayLen);
        int i = 0;
        while ((long)i < this.arrayLen) {
            InventoryItem.Type type;
            if (this.cursor + 36 > this.bytes.length) {
                throw new ProtocolException("Ran off the end of the INV");
            }
            int typeCode = (int)this.readUint32();
            switch (typeCode) {
                case 0: {
                    type = InventoryItem.Type.Error;
                    break;
                }
                case 1: {
                    type = InventoryItem.Type.Transaction;
                    break;
                }
                case 2: {
                    type = InventoryItem.Type.Block;
                    break;
                }
                default: {
                    throw new ProtocolException("Unknown CInv type: " + typeCode);
                }
            }
            InventoryItem item = new InventoryItem(type, this.readHash());
            this.items.add(item);
            ++i;
        }
        this.bytes = null;
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        stream.write(new VarInt(this.items.size()).encode());
        for (InventoryItem i : this.items) {
            Utils.uint32ToByteStreamLE(i.type.ordinal(), stream);
            stream.write(Utils.reverseBytes(i.hash.getBytes()));
        }
    }
}

