/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.common.base.Preconditions;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPool {
    private static final Logger log = LoggerFactory.getLogger(MemoryPool.class);
    private LinkedHashMap<Sha256Hash, Entry> memoryPool;
    private ReferenceQueue<Transaction> referenceQueue;
    public static final int MAX_SIZE = 1000;

    public MemoryPool(final int size) {
        this.memoryPool = new LinkedHashMap<Sha256Hash, Entry>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Sha256Hash, Entry> entry) {
                return this.size() > size;
            }
        };
        this.referenceQueue = new ReferenceQueue();
    }

    public MemoryPool() {
        this(1000);
    }

    private synchronized void cleanPool() {
        Reference<Transaction> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            WeakTransactionReference txRef = (WeakTransactionReference)ref;
            this.memoryPool.remove(txRef.hash);
        }
    }

    public synchronized int numBroadcastPeers(Sha256Hash txHash) {
        this.cleanPool();
        Entry entry = this.memoryPool.get(txHash);
        if (entry == null) {
            return 0;
        }
        if (entry.tx == null) {
            Preconditions.checkNotNull(entry.addresses);
            return entry.addresses.size();
        }
        if (entry.tx.get() == null) {
            this.memoryPool.remove(txHash);
            return 0;
        }
        Preconditions.checkState(entry.addresses == null);
        return ((Transaction)entry.tx.get()).getConfidence().numBroadcastPeers();
    }

    public synchronized Transaction seen(Transaction tx, PeerAddress byPeer) {
        this.cleanPool();
        Entry entry = this.memoryPool.get(tx.getHash());
        if (entry != null) {
            if (entry.tx != null) {
                Preconditions.checkState(entry.addresses == null);
                Transaction transaction = (Transaction)entry.tx.get();
                if (transaction == null) {
                    log.info("{}: Provided with a transaction that we previously threw away: {}", byPeer, (Object)tx.getHash());
                } else {
                    tx = transaction;
                    log.info("{}: Provided with a transaction downloaded before: [{}] {}", new Object[]{byPeer, tx.getConfidence().numBroadcastPeers(), tx.getHash()});
                }
                tx.getConfidence().markBroadcastBy(byPeer);
                return tx;
            }
            Preconditions.checkNotNull(entry.addresses);
            entry.tx = new WeakTransactionReference(tx, this.referenceQueue);
            TransactionConfidence confidence = tx.getConfidence();
            for (PeerAddress a : entry.addresses) {
                confidence.markBroadcastBy(a);
            }
            entry.addresses = null;
            log.debug("{}: Adding tx [{}] {} to the memory pool", new Object[]{byPeer, confidence.numBroadcastPeers(), tx.getHashAsString()});
            return tx;
        }
        log.info("{}: Provided with a downloaded transaction we didn't see announced yet: {}", byPeer, (Object)tx.getHashAsString());
        entry = new Entry();
        entry.tx = new WeakTransactionReference(tx, this.referenceQueue);
        this.memoryPool.put(tx.getHash(), entry);
        tx.getConfidence().markBroadcastBy(byPeer);
        return tx;
    }

    public synchronized void seen(Sha256Hash hash, PeerAddress byPeer) {
        this.cleanPool();
        Entry entry = this.memoryPool.get(hash);
        if (entry != null) {
            if (entry.tx != null) {
                Preconditions.checkState(entry.addresses == null);
                Transaction tx = (Transaction)entry.tx.get();
                if (tx != null) {
                    tx.getConfidence().markBroadcastBy(byPeer);
                    log.debug("{}: Announced transaction we have seen before [{}] {}", new Object[]{byPeer, tx.getConfidence().numBroadcastPeers(), tx.getHashAsString()});
                }
            } else {
                Preconditions.checkNotNull(entry.addresses);
                entry.addresses.add(byPeer);
                log.debug("{}: Announced transaction we have seen announced before [{}] {}", new Object[]{byPeer, entry.addresses.size(), hash});
            }
        } else {
            entry = new Entry();
            entry.addresses = new HashSet<PeerAddress>();
            entry.addresses.add(byPeer);
            this.memoryPool.put(hash, entry);
            log.info("{}: Announced new transaction [1] {}", byPeer, (Object)hash);
        }
    }

    public synchronized Transaction get(Sha256Hash hash) {
        Entry entry = this.memoryPool.get(hash);
        if (entry == null) {
            return null;
        }
        if (entry.tx == null) {
            return null;
        }
        if (entry.tx.get() == null) {
            return null;
        }
        Transaction tx = (Transaction)entry.tx.get();
        Preconditions.checkNotNull(tx);
        return tx;
    }

    public synchronized boolean maybeWasSeen(Sha256Hash hash) {
        Entry entry = this.memoryPool.get(hash);
        return entry != null;
    }

    private static class Entry {
        Set<PeerAddress> addresses;
        WeakTransactionReference tx;

        private Entry() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakTransactionReference
    extends WeakReference<Transaction> {
        public Sha256Hash hash;

        public WeakTransactionReference(Transaction tx, ReferenceQueue<Transaction> queue) {
            super(tx, queue);
            this.hash = tx.getHash();
        }
    }
}

