/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractPeerEventListener;
import com.google.bitcoin.core.AbstractWalletEventListener;
import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.DownloadListener;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.MemoryPool;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.TCPNetworkConnection;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.discovery.PeerDiscovery;
import com.google.bitcoin.discovery.PeerDiscoveryException;
import com.google.bitcoin.utils.EventListenerInvoker;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerGroup {
    private static final int DEFAULT_CONNECTIONS = 4;
    private static final Logger log = LoggerFactory.getLogger(PeerGroup.class);
    public static final int DEFAULT_CONNECTION_DELAY_MILLIS = 5000;
    private BlockingQueue<PeerAddress> inactives;
    private PeerGroupThread peerGroupThread;
    private boolean running;
    private LinkedList<Peer> peers;
    private Set<Peer> pendingPeers;
    private Map<Peer, ChannelFuture> channelFutures;
    private Peer downloadPeer;
    private PeerEventListener downloadListener;
    private List<PeerEventListener> peerEventListeners;
    private Set<PeerDiscovery> peerDiscoverers;
    private VersionMessage versionMessage;
    private final MemoryPool memoryPool;
    private int maxConnections;
    private final NetworkParameters params;
    private int connectionDelayMillis;
    private long fastCatchupTimeSecs;
    private ArrayList<Wallet> wallets;
    private AbstractPeerEventListener getDataListener;
    private ClientBootstrap bootstrap;
    private int minBroadcastConnections = 0;
    Peer.PeerLifecycleListener startupListener = new PeerStartupListener();

    public PeerGroup(NetworkParameters params, BlockChain chain) {
        this(params, chain, 5000);
    }

    public PeerGroup(NetworkParameters params, BlockChain chain, int connectionDelayMillis) {
        this(params, chain, connectionDelayMillis, new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(new PeerGroupThreadFactory()), (Executor)Executors.newCachedThreadPool(new PeerGroupThreadFactory()))));
        this.bootstrap.setPipelineFactory(this.makePipelineFactory(params, chain));
    }

    PeerGroup(NetworkParameters params, BlockChain chain, int connectionDelayMillis, ClientBootstrap bootstrap) {
        this.params = params;
        this.connectionDelayMillis = connectionDelayMillis;
        this.fastCatchupTimeSecs = params.genesisBlock.getTimeSeconds();
        this.wallets = new ArrayList(1);
        this.maxConnections = 0;
        this.versionMessage = new VersionMessage(params, chain.getBestChainHeight());
        this.memoryPool = new MemoryPool();
        this.bootstrap = bootstrap;
        this.inactives = new LinkedBlockingQueue<PeerAddress>();
        this.peers = new LinkedList();
        this.pendingPeers = new HashSet<Peer>();
        this.channelFutures = new HashMap<Peer, ChannelFuture>();
        this.peerDiscoverers = new CopyOnWriteArraySet<PeerDiscovery>();
        this.peerEventListeners = new ArrayList<PeerEventListener>();
        this.getDataListener = new AbstractPeerEventListener(){

            @Override
            public List<Message> getData(Peer peer, GetDataMessage m) {
                return PeerGroup.this.handleGetData(m);
            }
        };
    }

    private ChannelPipelineFactory makePipelineFactory(final NetworkParameters params, final BlockChain chain) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                VersionMessage ver = PeerGroup.this.getVersionMessage().duplicate();
                ver.bestHeight = chain.getBestChainHeight();
                ver.time = Utils.now().getTime() / 1000L;
                ChannelPipeline p = Channels.pipeline();
                Peer peer = new Peer(params, chain, ver);
                peer.addLifecycleListener(PeerGroup.this.startupListener);
                PeerGroup.this.pendingPeers.add(peer);
                TCPNetworkConnection codec = new TCPNetworkConnection(params, peer.getVersionMessage());
                p.addLast("codec", (ChannelHandler)codec.getHandler());
                p.addLast("peer", (ChannelHandler)peer.getHandler());
                return p;
            }
        };
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List<Message> handleGetData(GetDataMessage m) {
        LinkedList<Message> transactions = new LinkedList<Message>();
        LinkedList<InventoryItem> items = new LinkedList<InventoryItem>(m.getItems());
        Iterator it = items.iterator();
        block3: while (it.hasNext()) {
            InventoryItem item = (InventoryItem)it.next();
            Transaction tx = this.memoryPool.get(item.hash);
            if (tx != null) {
                transactions.add(tx);
                it.remove();
                continue;
            }
            Iterator<Wallet> i$ = this.wallets.iterator();
            while (i$.hasNext()) {
                Wallet w;
                Wallet wallet = w = i$.next();
                synchronized (wallet) {
                    tx = w.getTransaction(item.hash);
                    if (tx == null) {
                        continue;
                    }
                    transactions.add(tx);
                    it.remove();
                    continue block3;
                }
            }
        }
        return transactions;
    }

    public synchronized void setVersionMessage(VersionMessage ver) {
        this.versionMessage = ver;
    }

    public synchronized VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public void setUserAgent(String name, String version, String comments) {
        VersionMessage ver = new VersionMessage(this.params, 0);
        ver.appendToSubVer(name, version, comments);
        this.setVersionMessage(ver);
    }

    public void setUserAgent(String name, String version) {
        this.setUserAgent(name, version, null);
    }

    public synchronized void addEventListener(PeerEventListener listener) {
        this.peerEventListeners.add(Preconditions.checkNotNull(listener));
    }

    public synchronized boolean removeEventListener(PeerEventListener listener) {
        return this.peerEventListeners.remove(Preconditions.checkNotNull(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<Peer> getConnectedPeers() {
        ArrayList<Peer> result = new ArrayList<Peer>(this.peers.size());
        LinkedList<Peer> linkedList = this.peers;
        synchronized (linkedList) {
            result.addAll(this.peers);
        }
        return result;
    }

    public synchronized void addAddress(PeerAddress peerAddress) {
        this.inactives.add(peerAddress);
        ++this.maxConnections;
    }

    public synchronized void addPeerDiscovery(PeerDiscovery peerDiscovery) {
        if (this.getMaxConnections() == 0) {
            this.setMaxConnections(4);
        }
        this.peerDiscoverers.add(peerDiscovery);
    }

    public synchronized void start() {
        this.peerGroupThread = new PeerGroupThread();
        this.running = true;
        this.peerGroupThread.start();
    }

    synchronized void mockStart(PeerGroupThread peerGroupThread) {
        this.peerGroupThread = peerGroupThread;
        this.running = true;
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.peerGroupThread.interrupt();
        }
    }

    public synchronized void addWallet(Wallet wallet) {
        Preconditions.checkNotNull(wallet);
        this.wallets.add(wallet);
        this.addEventListener(wallet.getPeerEventListener());
        this.announcePendingWalletTransactions(Collections.singletonList(wallet), this.peers);
        wallet.addEventListener(new AbstractWalletEventListener(){

            public void onKeyAdded(ECKey key) {
                PeerGroup.this.recalculateFastCatchupTime();
            }
        });
        this.recalculateFastCatchupTime();
    }

    private synchronized void recalculateFastCatchupTime() {
        long earliestKeyTime = Long.MAX_VALUE;
        for (Wallet w : this.wallets) {
            earliestKeyTime = Math.min(earliestKeyTime, w.getEarliestKeyCreationTime());
        }
        this.setFastCatchupTimeSecs(earliestKeyTime);
    }

    public void removeWallet(Wallet wallet) {
        if (wallet == null) {
            throw new IllegalArgumentException("wallet is null");
        }
        this.wallets.remove(wallet);
        this.removeEventListener(wallet.getPeerEventListener());
    }

    public synchronized int numConnectedPeers() {
        return this.peers.size();
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public ChannelFuture connectTo(SocketAddress address) {
        return this.connectTo(address, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChannelFuture connectTo(SocketAddress address, boolean incrementMaxConnections) {
        ChannelFuture future = this.bootstrap.connect(address);
        TCPNetworkConnection.NetworkHandler networkHandler = (TCPNetworkConnection.NetworkHandler)future.getChannel().getPipeline().get("codec");
        if (networkHandler != null) {
            networkHandler.getOwnerObject().setRemoteAddress(address);
        }
        PeerGroup peerGroup = this;
        synchronized (peerGroup) {
            Peer peer = PeerGroup.peerFromChannelFuture(future);
            this.channelFutures.put(peer, future);
            if (incrementMaxConnections) {
                this.setMaxConnections(this.getMaxConnections() + 1);
            }
        }
        return future;
    }

    public static Peer peerFromChannelFuture(ChannelFuture future) {
        return PeerGroup.peerFromChannel(future.getChannel());
    }

    public static Peer peerFromChannel(Channel channel) {
        return ((Peer.PeerHandler)channel.getPipeline().get("peer")).getPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startBlockChainDownload(PeerEventListener listener) {
        this.downloadListener = listener;
        LinkedList<Peer> linkedList = this.peers;
        synchronized (linkedList) {
            if (!this.peers.isEmpty()) {
                this.startBlockChainDownloadFromPeer((Peer)this.peers.iterator().next());
            }
        }
    }

    public void downloadBlockChain() {
        DownloadListener listener = new DownloadListener();
        this.startBlockChainDownload(listener);
        try {
            listener.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected synchronized void handleNewPeer(final Peer peer) {
        log.info("{}: New peer", peer);
        peer.setMemoryPool(this.memoryPool);
        if (this.downloadListener != null && this.downloadPeer == null) {
            log.info("  starting block chain download");
            this.startBlockChainDownloadFromPeer(peer);
        } else if (this.downloadPeer == null) {
            this.setDownloadPeer(peer);
        } else {
            peer.setDownloadData(false);
        }
        peer.addEventListener(this.getDataListener);
        this.announcePendingWalletTransactions(this.wallets, Collections.singletonList(peer));
        for (PeerEventListener listener : this.peerEventListeners) {
            peer.addEventListener(listener);
        }
        EventListenerInvoker.invoke(this.peerEventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onPeerConnected(peer, PeerGroup.this.peers.size());
            }
        });
    }

    private synchronized boolean announcePendingWalletTransactions(List<Wallet> announceWallets, List<Peer> announceToPeers) {
        InventoryMessage inv = new InventoryMessage(this.params);
        for (Wallet w : announceWallets) {
            for (Transaction tx : w.getPendingTransactions()) {
                inv.addTransaction(tx);
            }
        }
        if (inv.getItems().size() == 0) {
            return true;
        }
        boolean success = false;
        for (Peer p : announceToPeers) {
            try {
                log.info("{}: Announcing {} pending wallet transactions", p.getAddress(), (Object)inv.getItems().size());
                p.sendMessage(inv);
                success = true;
            }
            catch (IOException e) {
                log.warn("Failed to announce 'inv' to peer: {}", p);
            }
        }
        return success;
    }

    private synchronized void setDownloadPeer(Peer peer) {
        if (this.downloadPeer != null) {
            log.info("Unsetting download peer: {}", this.downloadPeer);
            this.downloadPeer.setDownloadData(false);
        }
        this.downloadPeer = peer;
        if (this.downloadPeer != null) {
            log.info("Setting download peer: {}", this.downloadPeer);
            this.downloadPeer.setDownloadData(true);
            this.downloadPeer.setFastCatchupTime(this.fastCatchupTimeSecs);
        }
    }

    public MemoryPool getMemoryPool() {
        return this.memoryPool;
    }

    public synchronized void setFastCatchupTimeSecs(long secondsSinceEpoch) {
        this.fastCatchupTimeSecs = secondsSinceEpoch;
        if (this.downloadPeer != null) {
            this.downloadPeer.setFastCatchupTime(secondsSinceEpoch);
        }
    }

    public synchronized long getFastCatchupTimeSecs() {
        return this.fastCatchupTimeSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void handlePeerDeath(final Peer peer) {
        if (!this.isRunning()) {
            log.info("Peer death while shutting down");
            return;
        }
        Preconditions.checkArgument(!this.peers.contains(peer));
        if (peer == this.downloadPeer) {
            log.info("Download peer died. Picking a new one.");
            this.setDownloadPeer(null);
            LinkedList<Peer> linkedList = this.peers;
            synchronized (linkedList) {
                if (!this.peers.isEmpty()) {
                    Peer next = this.peers.peekFirst();
                    this.setDownloadPeer(next);
                    if (this.downloadListener != null) {
                        this.startBlockChainDownloadFromPeer(next);
                    }
                }
            }
        }
        peer.removeEventListener(this.getDataListener);
        EventListenerInvoker.invoke(this.peerEventListeners, new EventListenerInvoker<PeerEventListener>(){

            @Override
            public void invoke(PeerEventListener listener) {
                listener.onPeerDisconnected(peer, PeerGroup.this.peers.size());
            }
        });
    }

    private synchronized void startBlockChainDownloadFromPeer(Peer peer) {
        try {
            peer.addEventListener(this.downloadListener);
            this.setDownloadPeer(peer);
            peer.startBlockChainDownload();
        }
        catch (IOException e) {
            log.error("failed to start block chain download from " + peer, e);
            return;
        }
    }

    public synchronized ListenableFuture<PeerGroup> waitForPeers(final int numPeers) {
        if (this.peers.size() >= numPeers) {
            return Futures.immediateFuture((Object)this);
        }
        final SettableFuture future = SettableFuture.create();
        this.addEventListener(new AbstractPeerEventListener(){

            public void onPeerConnected(Peer peer, int peerCount) {
                if (peerCount >= numPeers) {
                    future.set((Object)PeerGroup.this);
                    PeerGroup.this.removeEventListener(this);
                }
            }
        });
        return future;
    }

    public int getMinBroadcastConnections() {
        if (this.minBroadcastConnections == 0) {
            int max = this.getMaxConnections();
            if (max <= 1) {
                return max;
            }
            return (int)Math.round((double)this.getMaxConnections() / 2.0);
        }
        return this.minBroadcastConnections;
    }

    public void setMinBroadcastConnections(int value) {
        this.minBroadcastConnections = value;
    }

    public ListenableFuture<Transaction> broadcastTransaction(Transaction tx) {
        return this.broadcastTransaction(tx, this.getMinBroadcastConnections());
    }

    public ListenableFuture<Transaction> broadcastTransaction(final Transaction tx, final int minConnections) {
        final SettableFuture future = SettableFuture.create();
        log.info("Waiting for {} peers required for broadcast ...", minConnections);
        ListenableFuture<PeerGroup> peerAvailabilityFuture = this.waitForPeers(minConnections);
        peerAvailabilityFuture.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Peer somePeer = (Peer)PeerGroup.this.peers.getFirst();
                log.info("broadcastTransaction: Enough peers, adding {} to the memory pool and sending to {}", (Object)tx.getHashAsString(), (Object)somePeer);
                final Transaction pinnedTx = PeerGroup.this.memoryPool.seen(tx, somePeer.getAddress());
                try {
                    somePeer.sendMessage(pinnedTx);
                }
                catch (IOException e) {
                    future.setException((Throwable)e);
                    return;
                }
                if (minConnections == 1) {
                    PeerGroup peerGroup = PeerGroup.this;
                    synchronized (peerGroup) {
                        for (Wallet wallet : PeerGroup.this.wallets) {
                            try {
                                wallet.receivePending(pinnedTx);
                            }
                            catch (Throwable t) {
                                future.setException(t);
                                return;
                            }
                        }
                    }
                    future.set((Object)pinnedTx);
                    return;
                }
                tx.getConfidence().addEventListener(new TransactionConfidence.Listener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onConfidenceChanged(Transaction tx) {
                        int numSeenPeers = tx.getConfidence().getBroadcastBy().size();
                        boolean done = false;
                        log.info("broadcastTransaction: TX {} seen by {} peers", (Object)pinnedTx.getHashAsString(), (Object)numSeenPeers);
                        PeerGroup peerGroup = PeerGroup.this;
                        synchronized (peerGroup) {
                            if (numSeenPeers >= minConnections) {
                                for (Wallet wallet : PeerGroup.this.wallets) {
                                    try {
                                        wallet.receivePending(pinnedTx);
                                    }
                                    catch (Throwable t) {
                                        future.setException(t);
                                        return;
                                    }
                                }
                                done = true;
                            }
                        }
                        if (done) {
                            log.info("broadcastTransaction: {} complete", (Object)pinnedTx.getHashAsString());
                            future.set((Object)pinnedTx);
                        }
                    }
                });
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        return future;
    }

    static class PeerGroupThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        PeerGroupThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = "PeerGroup-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
            t.setDaemon(true);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PeerGroupThread
    extends Thread {
        private LinkedBlockingQueue<FutureTask> tasks;

        public PeerGroupThread() {
            super("Peer group thread");
            this.tasks = new LinkedBlockingQueue();
            this.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            try {
                while (PeerGroup.this.isRunning()) {
                    PeerGroup peerGroup = PeerGroup.this;
                    // MONITORENTER : peerGroup
                    int numPeers = PeerGroup.this.peers.size();
                    // MONITOREXIT : peerGroup
                    if (PeerGroup.this.inactives.size() == 0) {
                        this.discoverPeers();
                    } else if (numPeers < PeerGroup.this.getMaxConnections()) {
                        this.tryNextPeer();
                    }
                    if (numPeers > 0) {
                        FutureTask task = this.tasks.poll(PeerGroup.this.connectionDelayMillis, TimeUnit.MILLISECONDS);
                        if (task == null) continue;
                        object = PeerGroup.this;
                        // MONITORENTER : object
                        task.run();
                        // MONITOREXIT : object
                        continue;
                    }
                    Thread.sleep(PeerGroup.this.connectionDelayMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.info("shutdown start");
            PeerGroup peerGroup = PeerGroup.this;
            // MONITORENTER : peerGroup
            PeerGroup.this.running = false;
            this.shutdownPeerDiscovery();
            object = PeerGroup.this.channelFutures;
            // MONITORENTER : object
            LinkedList futures = new LinkedList(PeerGroup.this.channelFutures.values());
            // MONITOREXIT : object
            Iterator i$ = futures.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    PeerGroup.this.bootstrap.releaseExternalResources();
                    // MONITOREXIT : peerGroup
                    log.info("shutdown done");
                    return;
                }
                ChannelFuture future = (ChannelFuture)i$.next();
                future.getChannel().close();
            }
        }

        private void discoverPeers() {
            for (PeerDiscovery peerDiscovery : PeerGroup.this.peerDiscoverers) {
                InetSocketAddress[] addresses;
                try {
                    addresses = peerDiscovery.getPeers();
                }
                catch (PeerDiscoveryException e) {
                    log.error("Failed to discover peer addresses from discovery source", e);
                    return;
                }
                for (int i = 0; i < addresses.length; ++i) {
                    PeerGroup.this.inactives.add(new PeerAddress(addresses[i]));
                }
                if (PeerGroup.this.inactives.size() <= 0) continue;
                break;
            }
        }

        private void shutdownPeerDiscovery() {
            for (PeerDiscovery peerDiscovery : PeerGroup.this.peerDiscoverers) {
                peerDiscovery.shutdown();
            }
        }

        private void tryNextPeer() throws InterruptedException {
            PeerAddress address = (PeerAddress)PeerGroup.this.inactives.take();
            PeerGroup.this.connectTo(address.toSocketAddress(), false);
        }

        public synchronized <T> void addTask(FutureTask<T> task) {
            this.tasks.add(task);
        }
    }

    private class PeerStartupListener
    implements Peer.PeerLifecycleListener {
        private PeerStartupListener() {
        }

        public void onPeerConnected(Peer peer) {
            PeerGroup.this.pendingPeers.remove(peer);
            PeerGroup.this.peers.add(peer);
            PeerGroup.this.handleNewPeer(peer);
        }

        public void onPeerDisconnected(Peer peer) {
            PeerGroup.this.pendingPeers.remove(peer);
            PeerGroup.this.peers.remove(peer);
            PeerGroup.this.channelFutures.remove(peer);
            PeerGroup.this.handlePeerDeath(peer);
        }
    }
}

