/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Utils;
import java.io.IOException;
import java.io.OutputStream;

public class Pong
extends Message {
    private long nonce;

    public Pong(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public Pong(long nonce) {
        this.nonce = nonce;
    }

    void parse() throws ProtocolException {
        this.nonce = this.readInt64();
        this.length = 8;
    }

    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.int64ToByteStreamLE(this.nonce, stream);
    }

    protected void parseLite() {
    }

    long getNonce() {
        return this.nonce;
    }
}

