/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ScriptChunk;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.UnsafeByteArrayOutputStream;
import com.google.bitcoin.core.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class Script {
    public static final int OP_0 = 0;
    public static final int OP_FALSE = 0;
    public static final int OP_PUSHDATA1 = 76;
    public static final int OP_PUSHDATA2 = 77;
    public static final int OP_PUSHDATA4 = 78;
    public static final int OP_1NEGATE = 79;
    public static final int OP_RESERVED = 80;
    public static final int OP_1 = 81;
    public static final int OP_TRUE = 81;
    public static final int OP_2 = 82;
    public static final int OP_3 = 83;
    public static final int OP_4 = 84;
    public static final int OP_5 = 85;
    public static final int OP_6 = 86;
    public static final int OP_7 = 87;
    public static final int OP_8 = 88;
    public static final int OP_9 = 89;
    public static final int OP_10 = 90;
    public static final int OP_11 = 91;
    public static final int OP_12 = 92;
    public static final int OP_13 = 93;
    public static final int OP_14 = 94;
    public static final int OP_15 = 95;
    public static final int OP_16 = 96;
    public static final int OP_NOP = 97;
    public static final int OP_VER = 98;
    public static final int OP_IF = 99;
    public static final int OP_NOTIF = 100;
    public static final int OP_VERIF = 101;
    public static final int OP_VERNOTIF = 102;
    public static final int OP_ELSE = 103;
    public static final int OP_ENDIF = 104;
    public static final int OP_VERIFY = 105;
    public static final int OP_RETURN = 106;
    public static final int OP_TOALTSTACK = 107;
    public static final int OP_FROMALTSTACK = 108;
    public static final int OP_2DROP = 109;
    public static final int OP_2DUP = 110;
    public static final int OP_3DUP = 111;
    public static final int OP_2OVER = 112;
    public static final int OP_2ROT = 113;
    public static final int OP_2SWAP = 114;
    public static final int OP_IFDUP = 115;
    public static final int OP_DEPTH = 116;
    public static final int OP_DROP = 117;
    public static final int OP_DUP = 118;
    public static final int OP_NIP = 119;
    public static final int OP_OVER = 120;
    public static final int OP_PICK = 121;
    public static final int OP_ROLL = 122;
    public static final int OP_ROT = 123;
    public static final int OP_SWAP = 124;
    public static final int OP_TUCK = 125;
    public static final int OP_CAT = 126;
    public static final int OP_SUBSTR = 127;
    public static final int OP_LEFT = 128;
    public static final int OP_RIGHT = 129;
    public static final int OP_SIZE = 130;
    public static final int OP_INVERT = 131;
    public static final int OP_AND = 132;
    public static final int OP_OR = 133;
    public static final int OP_XOR = 134;
    public static final int OP_EQUAL = 135;
    public static final int OP_EQUALVERIFY = 136;
    public static final int OP_RESERVED1 = 137;
    public static final int OP_RESERVED2 = 138;
    public static final int OP_1ADD = 139;
    public static final int OP_1SUB = 140;
    public static final int OP_2MUL = 141;
    public static final int OP_2DIV = 142;
    public static final int OP_NEGATE = 143;
    public static final int OP_ABS = 144;
    public static final int OP_NOT = 145;
    public static final int OP_0NOTEQUAL = 146;
    public static final int OP_ADD = 147;
    public static final int OP_SUB = 148;
    public static final int OP_MUL = 149;
    public static final int OP_DIV = 150;
    public static final int OP_MOD = 151;
    public static final int OP_LSHIFT = 152;
    public static final int OP_RSHIFT = 153;
    public static final int OP_BOOLAND = 154;
    public static final int OP_BOOLOR = 155;
    public static final int OP_NUMEQUAL = 156;
    public static final int OP_NUMEQUALVERIFY = 157;
    public static final int OP_NUMNOTEQUAL = 158;
    public static final int OP_LESSTHAN = 159;
    public static final int OP_GREATERTHAN = 160;
    public static final int OP_LESSTHANOREQUAL = 161;
    public static final int OP_GREATERTHANOREQUAL = 162;
    public static final int OP_MIN = 163;
    public static final int OP_MAX = 164;
    public static final int OP_WITHIN = 165;
    public static final int OP_RIPEMD160 = 166;
    public static final int OP_SHA1 = 167;
    public static final int OP_SHA256 = 168;
    public static final int OP_HASH160 = 169;
    public static final int OP_HASH256 = 170;
    public static final int OP_CODESEPARATOR = 171;
    public static final int OP_CHECKSIG = 172;
    public static final int OP_CHECKSIGVERIFY = 173;
    public static final int OP_CHECKMULTISIG = 174;
    public static final int OP_CHECKMULTISIGVERIFY = 175;
    public static final int OP_NOP1 = 176;
    public static final int OP_NOP2 = 177;
    public static final int OP_NOP3 = 178;
    public static final int OP_NOP4 = 179;
    public static final int OP_NOP5 = 180;
    public static final int OP_NOP6 = 181;
    public static final int OP_NOP7 = 182;
    public static final int OP_NOP8 = 183;
    public static final int OP_NOP9 = 184;
    public static final int OP_NOP10 = 185;
    public static final int OP_INVALIDOPCODE = 255;
    byte[] program;
    private int cursor;
    List<ScriptChunk> chunks;
    private final NetworkParameters params;

    public Script(NetworkParameters params, byte[] programBytes, int offset, int length) throws ScriptException {
        this.params = params;
        this.parse(programBytes, offset, length);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (ScriptChunk chunk : this.chunks) {
            if (chunk.isOpCode) {
                buf.append(Script.getOpCodeName(chunk.data[0]));
                buf.append(" ");
                continue;
            }
            buf.append("[");
            buf.append(Utils.bytesToHexString(chunk.data));
            buf.append("] ");
        }
        return buf.toString();
    }

    public static String getOpCodeName(byte opCode) {
        int opcode = opCode & 0xFF;
        switch (opcode) {
            case 0: {
                return "0";
            }
            case 76: {
                return "PUSHDATA1";
            }
            case 77: {
                return "PUSHDATA1";
            }
            case 78: {
                return "PUSHDATA4";
            }
            case 79: {
                return "1NEGATE";
            }
            case 80: {
                return "RESERVED";
            }
            case 81: {
                return "1";
            }
            case 82: {
                return "2";
            }
            case 83: {
                return "3";
            }
            case 84: {
                return "4";
            }
            case 85: {
                return "5";
            }
            case 86: {
                return "6";
            }
            case 87: {
                return "7";
            }
            case 88: {
                return "8";
            }
            case 89: {
                return "9";
            }
            case 90: {
                return "10";
            }
            case 91: {
                return "11";
            }
            case 92: {
                return "12";
            }
            case 93: {
                return "13";
            }
            case 94: {
                return "14";
            }
            case 95: {
                return "15";
            }
            case 96: {
                return "16";
            }
            case 97: {
                return "NOP";
            }
            case 98: {
                return "VER";
            }
            case 99: {
                return "IF";
            }
            case 100: {
                return "NOTIF";
            }
            case 101: {
                return "VERIF";
            }
            case 102: {
                return "VERNOTIF";
            }
            case 103: {
                return "ELSE";
            }
            case 104: {
                return "ENDIF";
            }
            case 105: {
                return "VERIFY";
            }
            case 106: {
                return "RETURN";
            }
            case 107: {
                return "TOALTSTACK";
            }
            case 108: {
                return "FROMALTSTACK";
            }
            case 109: {
                return "2DROP";
            }
            case 110: {
                return "2DUP";
            }
            case 111: {
                return "3DUP";
            }
            case 112: {
                return "2OVER";
            }
            case 113: {
                return "2ROT";
            }
            case 114: {
                return "2SWAP";
            }
            case 115: {
                return "IFDUP";
            }
            case 116: {
                return "DEPTH";
            }
            case 117: {
                return "DROP";
            }
            case 118: {
                return "DUP";
            }
            case 119: {
                return "NIP";
            }
            case 120: {
                return "OVER";
            }
            case 121: {
                return "PICK";
            }
            case 122: {
                return "ROLL";
            }
            case 123: {
                return "ROT";
            }
            case 124: {
                return "SWAP";
            }
            case 125: {
                return "TUCK";
            }
            case 126: {
                return "CAT";
            }
            case 127: {
                return "SUBSTR";
            }
            case 128: {
                return "LEFT";
            }
            case 129: {
                return "RIGHT";
            }
            case 130: {
                return "SIZE";
            }
            case 131: {
                return "INVERT";
            }
            case 132: {
                return "AND";
            }
            case 133: {
                return "OR";
            }
            case 134: {
                return "XOR";
            }
            case 135: {
                return "EQUAL";
            }
            case 136: {
                return "EQUALVERIFY";
            }
            case 137: {
                return "RESERVED1";
            }
            case 138: {
                return "RESERVED2";
            }
            case 139: {
                return "1ADD";
            }
            case 140: {
                return "1SUB";
            }
            case 141: {
                return "2MUL";
            }
            case 142: {
                return "2DIV";
            }
            case 143: {
                return "NEGATE";
            }
            case 144: {
                return "ABS";
            }
            case 145: {
                return "NOT";
            }
            case 146: {
                return "0NOTEQUAL";
            }
            case 147: {
                return "ADD";
            }
            case 148: {
                return "SUB";
            }
            case 149: {
                return "MUL";
            }
            case 150: {
                return "DIV";
            }
            case 151: {
                return "MOD";
            }
            case 152: {
                return "LSHIFT";
            }
            case 153: {
                return "RSHIFT";
            }
            case 154: {
                return "BOOLAND";
            }
            case 155: {
                return "BOOLOR";
            }
            case 156: {
                return "NUMEQUAL";
            }
            case 157: {
                return "NUMEQUALVERIFY";
            }
            case 158: {
                return "NUMNOTEQUAL";
            }
            case 159: {
                return "LESSTHAN";
            }
            case 160: {
                return "GREATERTHAN";
            }
            case 161: {
                return "LESSTHANOREQUAL";
            }
            case 162: {
                return "GREATERTHANOREQUAL";
            }
            case 163: {
                return "MIN";
            }
            case 164: {
                return "MAX";
            }
            case 165: {
                return "WITHIN";
            }
            case 166: {
                return "RIPEMD160";
            }
            case 167: {
                return "SHA1";
            }
            case 168: {
                return "SHA256";
            }
            case 169: {
                return "HASH160";
            }
            case 170: {
                return "HASH256";
            }
            case 171: {
                return "CODESEPARATOR";
            }
            case 172: {
                return "CHECKSIG";
            }
            case 173: {
                return "CHECKSIGVERIFY";
            }
            case 174: {
                return "CHECKMULTISIG";
            }
            case 175: {
                return "CHECKMULTISIGVERIFY";
            }
            case 176: {
                return "NOP1";
            }
            case 177: {
                return "NOP2";
            }
            case 178: {
                return "NOP3";
            }
            case 179: {
                return "NOP4";
            }
            case 180: {
                return "NOP5";
            }
            case 181: {
                return "NOP6";
            }
            case 182: {
                return "NOP7";
            }
            case 183: {
                return "NOP8";
            }
            case 184: {
                return "NOP9";
            }
            case 185: {
                return "NOP10";
            }
        }
        return "NON_OP(" + opcode + ")";
    }

    private byte[] getData(int len) throws ScriptException {
        if (len > this.program.length - this.cursor) {
            throw new ScriptException("Failed read of " + len + " bytes");
        }
        try {
            byte[] buf = new byte[len];
            System.arraycopy(this.program, this.cursor, buf, 0, len);
            this.cursor += len;
            return buf;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ScriptException("Failed read of " + len + " bytes", e);
        }
        catch (NegativeArraySizeException e) {
            throw new ScriptException("Failed read of " + len + " bytes", e);
        }
    }

    private int readByte() throws ScriptException {
        try {
            return 0xFF & this.program[this.cursor++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ScriptException("Attempted to read outside of script boundaries");
        }
    }

    private void parse(byte[] programBytes, int offset, int length) throws ScriptException {
        this.program = new byte[length];
        System.arraycopy(programBytes, offset, this.program, 0, length);
        offset = 0;
        this.chunks = new ArrayList<ScriptChunk>(10);
        this.cursor = offset;
        while (this.cursor < offset + length) {
            int opcode = this.readByte();
            if (opcode >= 0 && opcode < 76) {
                this.chunks.add(new ScriptChunk(false, this.getData(opcode)));
                continue;
            }
            if (opcode == 76) {
                int len = this.readByte();
                this.chunks.add(new ScriptChunk(false, this.getData(len)));
                continue;
            }
            if (opcode == 77) {
                int len = this.readByte() | this.readByte() << 8;
                this.chunks.add(new ScriptChunk(false, this.getData(len)));
                continue;
            }
            if (opcode == 78) {
                long len = this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
                this.chunks.add(new ScriptChunk(false, this.getData((int)len)));
                continue;
            }
            this.chunks.add(new ScriptChunk(true, new byte[]{(byte)opcode}));
        }
    }

    public boolean isSentToRawPubKey() {
        if (this.chunks.size() != 2) {
            return false;
        }
        return this.chunks.get(1).equalsOpCode(172) && !this.chunks.get((int)0).isOpCode && this.chunks.get((int)0).data.length > 1;
    }

    public boolean isSentToAddress() {
        if (this.chunks.size() != 5) {
            return false;
        }
        return this.chunks.get(0).equalsOpCode(118) && this.chunks.get(1).equalsOpCode(169) && this.chunks.get((int)2).data.length == 20 && this.chunks.get(3).equalsOpCode(136) && this.chunks.get(4).equalsOpCode(172);
    }

    public byte[] getPubKeyHash() throws ScriptException {
        if (!this.isSentToAddress()) {
            throw new ScriptException("Script not in the standard scriptPubKey form");
        }
        return this.chunks.get((int)2).data;
    }

    public byte[] getPubKey() throws ScriptException {
        if (this.chunks.size() != 2) {
            throw new ScriptException("Script not of right size, expecting 2 but got " + this.chunks.size());
        }
        if (this.chunks.get((int)0).data.length > 2 && this.chunks.get((int)1).data.length > 2) {
            return this.chunks.get((int)1).data;
        }
        if (this.chunks.get((int)1).data.length == 1 && this.chunks.get(1).equalsOpCode(172) && this.chunks.get((int)0).data.length > 2) {
            return this.chunks.get((int)0).data;
        }
        throw new ScriptException("Script did not match expected form: " + this.toString());
    }

    public Address getFromAddress() throws ScriptException {
        return new Address(this.params, Utils.sha256hash160(this.getPubKey()));
    }

    public Address getToAddress() throws ScriptException {
        return new Address(this.params, this.getPubKeyHash());
    }

    static void writeBytes(OutputStream os, byte[] buf) throws IOException {
        if (buf.length < 76) {
            os.write(buf.length);
            os.write(buf);
        } else if (buf.length < 256) {
            os.write(76);
            os.write(buf.length);
            os.write(buf);
        } else if (buf.length < 65536) {
            os.write(77);
            os.write(0xFF & buf.length);
            os.write(0xFF & buf.length >> 8);
            os.write(buf);
        } else {
            throw new RuntimeException("Unimplemented");
        }
    }

    public static byte[] createOutputScript(Address to) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(24);
            ((ByteArrayOutputStream)bits).write(118);
            ((ByteArrayOutputStream)bits).write(169);
            Script.writeBytes(bits, to.getHash160());
            ((ByteArrayOutputStream)bits).write(136);
            ((ByteArrayOutputStream)bits).write(172);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createOutputScript(byte[] pubkey) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(pubkey.length + 1);
            Script.writeBytes(bits, pubkey);
            ((ByteArrayOutputStream)bits).write(172);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createOutputScript(ECKey pubkey) {
        return Script.createOutputScript(pubkey.getPubKey());
    }

    public static byte[] createInputScript(byte[] signature, byte[] pubkey) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(signature.length + pubkey.length + 2);
            Script.writeBytes(bits, signature);
            Script.writeBytes(bits, pubkey);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] createInputScript(byte[] signature) {
        try {
            UnsafeByteArrayOutputStream bits = new UnsafeByteArrayOutputStream(signature.length + 2);
            Script.writeBytes(bits, signature);
            return ((ByteArrayOutputStream)bits).toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

