/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Utils;

public class VarInt {
    public final long value;

    public VarInt(long value) {
        this.value = value;
    }

    public VarInt(byte[] buf, int offset) {
        int first = 0xFF & buf[offset];
        long val = first < 253 ? (long)first : (first == 253 ? (long)(0xFF & buf[offset + 1] | (0xFF & buf[offset + 2]) << 8) : (first == 254 ? Utils.readUint32(buf, offset + 1) : Utils.readUint32(buf, offset + 1) | Utils.readUint32(buf, offset + 5) << 32));
        this.value = val;
    }

    public int getSizeInBytes() {
        return VarInt.sizeOf(this.value);
    }

    public static int sizeOf(int value) {
        if (value < 253) {
            return 1;
        }
        if (value < 65536) {
            return 3;
        }
        return 5;
    }

    public static int sizeOf(long value) {
        if (Utils.isLessThanUnsigned(value, 253L)) {
            return 1;
        }
        if (Utils.isLessThanUnsigned(value, 65536L)) {
            return 3;
        }
        if (Utils.isLessThanUnsigned(value, 0x100000000L)) {
            return 5;
        }
        return 9;
    }

    public byte[] encode() {
        return this.encodeBE();
    }

    public byte[] encodeBE() {
        if (Utils.isLessThanUnsigned(this.value, 253L)) {
            return new byte[]{(byte)this.value};
        }
        if (Utils.isLessThanUnsigned(this.value, 65536L)) {
            return new byte[]{-3, (byte)this.value, (byte)(this.value >> 8)};
        }
        if (Utils.isLessThanUnsigned(this.value, 0xFFFFFFFFL)) {
            byte[] bytes = new byte[5];
            bytes[0] = -2;
            Utils.uint32ToByteArrayLE(this.value, bytes, 1);
            return bytes;
        }
        byte[] bytes = new byte[9];
        bytes[0] = -1;
        Utils.uint32ToByteArrayLE(this.value, bytes, 1);
        Utils.uint32ToByteArrayLE(this.value >>> 32, bytes, 5);
        return bytes;
    }
}

