/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.google.bitcoin.core.Block;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Random;
import java.util.Scanner;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import sockthing.Config;

public class BitcoinRPC {
    private String username;
    private String password;
    private String host;
    private int port;

    public BitcoinRPC(Config config) {
        config.require("bitcoind_username");
        config.require("bitcoind_password");
        config.require("bitcoind_host");
        config.require("bitcoind_port");
        this.username = config.get("bitcoind_username");
        this.password = config.get("bitcoind_password");
        this.host = config.get("bitcoind_host");
        this.port = config.getInt("bitcoind_port");
    }

    private String getUrl() {
        return "http://" + this.host + ":" + this.port + "/";
    }

    private String getUrlCommand(String cmd) {
        return this.getUrl();
    }

    public JSONObject sendPost(JSONObject post) throws IOException, JSONException {
        String str = this.sendPost(this.getUrl(), post.toString());
        return new JSONObject(str);
    }

    protected String sendPost(String url, String postdata) throws IOException {
        URL u = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        String basic = this.username + ":" + this.password;
        String encoded = Base64.encodeBase64String(basic.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", "" + Integer.toString(postdata.getBytes().length));
        connection.setUseCaches(false);
        OutputStream wr = connection.getOutputStream();
        wr.write(postdata.getBytes());
        wr.flush();
        wr.close();
        Scanner scan = new Scanner(connection.getInputStream());
        StringBuilder sb = new StringBuilder();
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            sb.append(line);
            sb.append('\n');
        }
        scan.close();
        return sb.toString();
    }

    public static String getSimplePostRequest(String cmd) {
        return "{\"method\":\"" + cmd + "\",\"params\":[],\"id\":1}\n";
    }

    public JSONObject doSimplePostRequest(String cmd) throws IOException, JSONException {
        return this.sendPost(new JSONObject(BitcoinRPC.getSimplePostRequest(cmd)));
    }

    public JSONObject submitBlock(Block blk) throws IOException, JSONException {
        Random rnd = new Random();
        JSONObject msg = new JSONObject();
        msg.put("method", "submitblock");
        msg.put("id", "" + rnd.nextInt());
        JSONArray params = new JSONArray();
        params.put(Hex.encodeHexString(blk.bitcoinSerialize()));
        msg.put("params", params);
        return this.sendPost(msg);
    }
}

