/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import com.google.bitcoin.core.Sha256Hash;
import java.math.BigInteger;

public class DiffMath {
    public static Sha256Hash getTargetForDifficulty(int diff) {
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger diff_one = two.pow(224);
        BigInteger diff_target = diff_one.divide(BigInteger.valueOf(diff));
        String target = diff_target.toString(16).toLowerCase();
        while (target.length() < 64) {
            target = "0" + target;
        }
        return new Sha256Hash(target);
    }

    private static void printDiff(int diff) {
        String diff_str = "" + diff;
        while (diff_str.length() < 10) {
            diff_str = diff_str + " ";
        }
        System.out.println(" " + diff_str + " - " + DiffMath.getTargetForDifficulty(diff));
    }

    public static void main(String[] args) {
        DiffMath.printDiff(1);
        DiffMath.printDiff(2);
        DiffMath.printDiff(3);
        DiffMath.printDiff(4);
        DiffMath.printDiff(32);
        DiffMath.printDiff(65536);
    }
}

