/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import sockthing.DB;
import sockthing.StratumServer;

public class PPLNSAgent
extends Thread {
    public static final long DB_CHECK_MS = 120000L;
    private long last_check;
    private HashMap<String, Double> last_map;
    private StratumServer server;

    public PPLNSAgent(StratumServer server) {
        this.setDaemon(true);
        this.setName("PPLNSAgent");
        this.server = server;
    }

    public synchronized HashMap<String, Double> getUserMap() {
        this.notifyAll();
        return this.last_map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.updateUserMap();
                    PPLNSAgent pPLNSAgent = this;
                    synchronized (pPLNSAgent) {
                        this.wait(30000L);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserMap() throws SQLException, JSONException, IOException {
        if (System.currentTimeMillis() > this.last_check + 120000L) {
            Connection conn = null;
            try {
                double network_diff = this.server.getDifficulty();
                double diff1shares = 0.0;
                conn = DB.openConnection("share_db");
                PreparedStatement ps = conn.prepareStatement("select * from shares where our_result='Y' order by time desc limit ?");
                ps.setLong(1, Math.round(network_diff / 32.0));
                ResultSet rs = ps.executeQuery();
                HashMap<String, Double> slice_map = new HashMap<String, Double>(512, 0.5f);
                while (rs.next() && diff1shares + 0.001 < network_diff) {
                    String user = rs.getString("username");
                    long share_diff = rs.getLong("difficulty");
                    double apply_diff = Math.min((double)share_diff, network_diff - diff1shares);
                    diff1shares += apply_diff;
                    double fee = 0.0175 + 0.1325 / Math.pow(share_diff, 0.6);
                    fee = 0.0;
                    double slice = 25.0 * (1.0 - fee) * apply_diff / network_diff;
                    if (!slice_map.containsKey(user)) {
                        slice_map.put(user, slice);
                        continue;
                    }
                    slice_map.put(user, slice + (Double)slice_map.get(user));
                }
                rs.close();
                ps.close();
                for (Map.Entry me : slice_map.entrySet()) {
                    DecimalFormat df = new DecimalFormat("0.00000000");
                    System.out.println((String)me.getKey() + ": " + df.format(me.getValue()));
                }
                System.out.println("Total: " + this.sum(slice_map.values()));
                this.last_map = slice_map;
                this.last_check = System.currentTimeMillis();
            }
            catch (Throwable throwable) {
                DB.safeClose(conn);
                throw throwable;
            }
            DB.safeClose(conn);
        }
    }

    public double sum(Collection<Double> vals) {
        double x = 0.0;
        for (Double d : vals) {
            x += d.doubleValue();
        }
        return x;
    }
}

