/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;
import sockthing.JobInfo;
import sockthing.LRUCache;
import sockthing.StratumServer;

public class UserSessionData {
    private LRUCache<String, JobInfo> open_jobs = new LRUCache(25);
    private AtomicLong next_job_id = new AtomicLong(0L);
    private String job_session_str;
    private StratumServer server;

    public UserSessionData(StratumServer server) {
        this.server = server;
        Random rnd = new Random();
        long session_id = Math.abs(rnd.nextInt());
        this.job_session_str = Long.toString(session_id, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getJobInfo(String job_id) {
        LRUCache<String, JobInfo> lRUCache = this.open_jobs;
        synchronized (lRUCache) {
            return (JobInfo)this.open_jobs.get(job_id);
        }
    }

    public String getNextJobId() {
        return "job_" + this.job_session_str + "_" + this.next_job_id.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJobInfo(String job_id, JobInfo ji) {
        LRUCache<String, JobInfo> lRUCache = this.open_jobs;
        synchronized (lRUCache) {
            this.open_jobs.put(job_id, ji);
        }
    }

    public static byte[] getExtranonce1() {
        return "SOCK".getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prune() throws JSONException, IOException {
        TreeSet to_delete = new TreeSet();
        int current_block_height = this.server.getCurrentBlockTemplate().getInt("height");
        LRUCache<String, JobInfo> lRUCache = this.open_jobs;
        synchronized (lRUCache) {
            if (this.open_jobs.size() == 0) {
                return true;
            }
            for (Map.Entry me : this.open_jobs.entrySet()) {
                JobInfo ji = (JobInfo)me.getValue();
                if (ji.getHeight() + 1 >= current_block_height) continue;
                to_delete.add(me.getKey());
            }
            for (String job_id : to_delete) {
                this.open_jobs.remove(job_id);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobCount() {
        LRUCache<String, JobInfo> lRUCache = this.open_jobs;
        synchronized (lRUCache) {
            return this.open_jobs.size();
        }
    }
}

