/*
 * Decompiled with CFR 0.152.
 */
package sockthing;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import sockthing.DB;

public class WittyRemarks
extends Thread {
    public static final long DB_CHECK_MS = 120000L;
    private long last_check;
    private String last_remark;

    public WittyRemarks() {
        this.setDaemon(true);
        this.setName("WittyRemarks");
    }

    public synchronized String getNextRemark() {
        this.notifyAll();
        return this.last_remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.updateLastRemark();
                    WittyRemarks wittyRemarks = this;
                    synchronized (wittyRemarks) {
                        this.wait(30000L);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastRemark() {
        if (System.currentTimeMillis() > this.last_check + 120000L) {
            Connection conn = null;
            try {
                conn = DB.openConnection("share_db");
                PreparedStatement ps = conn.prepareStatement("select * from witty_remarks where used=false order by order_id asc limit 1");
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    this.last_remark = rs.getString("remark");
                    int order = rs.getInt("order_id");
                    System.out.println("Witty remark selected (" + order + ") - '" + this.last_remark + "'");
                } else {
                    System.out.println("No more witty remarks");
                    this.last_remark = null;
                }
                rs.close();
                ps.close();
                this.last_check = System.currentTimeMillis();
            }
            catch (SQLException e) {
                System.out.println("Error getting remark: " + e);
            }
            finally {
                DB.safeClose(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markUsed(String remark) {
        Connection conn = null;
        try {
            conn = DB.openConnection("share_db");
            PreparedStatement ps = conn.prepareStatement("update witty_remarks set used=true where remark=?");
            ps.setString(1, remark);
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            System.out.println("Failed to mark remark as no longer remarkable: " + e);
        }
        finally {
            DB.safeClose(conn);
        }
        WittyRemarks wittyRemarks = this;
        synchronized (wittyRemarks) {
            this.last_check = 0L;
            this.notifyAll();
        }
    }
}

